/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class Parser
implements IParser {
    protected static final String UNKNOWN_HOST = "Unknown Host";
    public static final int defaultArraySize = 50;
    protected int MessageArraySize = 50;
    protected CommonBaseEvent[] messages;
    protected int arrayIndex;
    protected int recordCount = 0;
    protected String originLocale;
    protected String localHostId;
    protected String localHostIdFormat;
    protected String localHostName;
    protected String file_path;
    protected RandomAccessFile logFile;
    protected String curLine = "";
    protected static EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.parsers.Parser");
    protected Log logger;
    protected long curLineNumber = 0L;

    public void parse(Log argLogger) throws LogParserException {
        try {
            this.logger = argLogger;
            this.preParse();
            CommonBaseEvent[] msgArray = this.parseNext();
            while (msgArray != null) {
                for (int i = 0; i < msgArray.length; ++i) {
                    if (msgArray[i] == null) continue;
                    this.logger.trace((Object)msgArray[i]);
                }
                msgArray = this.parseNext();
            }
            this.postParse();
        }
        catch (Throwable e) {
            this.postParse();
            LogParserException lpe = new LogParserException(e);
            lpe.fillInStackTrace();
            throw lpe;
        }
    }

    public abstract CommonBaseEvent[] parseNext() throws LogParserException;

    public abstract String getName();

    public abstract String getVersion();

    public CommonBaseEvent[] getMessages() {
        return this.messages;
    }

    public void preParse() throws LogParserException {
        this.getLocalHostId();
        this.originLocale = this.getLocale();
    }

    public void setUserInput(Hashtable table) throws LogParserException {
        this.setConfiguration(table);
    }

    public void setConfiguration(Hashtable table) throws LogParserException {
        this.file_path = null;
        try {
            Integer array_size;
            this.file_path = (String)table.get("file_path");
            if (this.file_path != null) {
                this.file_path = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? this.file_path.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : this.file_path.replace('/', ParserConstants.FILE_SEPARATOR_CHARACTER);
                File file = new File(this.file_path);
                if (!file.isFile()) {
                    throw new FileNotFoundException("The file: " + this.file_path + " does not exist");
                }
                if (!file.canRead()) {
                    throw new IOException("The file: " + this.file_path + " cannot be read");
                }
                this.logFile = new RandomAccessFile(file, "r");
            }
            if ((array_size = (Integer)table.get("array_size")) != null) {
                this.MessageArraySize = array_size;
            }
            this.messages = new CommonBaseEvent[this.MessageArraySize];
            for (int i = 0; i < this.MessageArraySize; ++i) {
                this.messages[i] = eventFactory.createCommonBaseEvent();
            }
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
        }
    }

    protected void increaseMsgArraySize() {
        CommonBaseEvent[] tempArray = new CommonBaseEvent[++this.MessageArraySize];
        System.arraycopy(this.messages, 0, tempArray, 0, this.messages.length);
        this.messages = tempArray;
        this.messages[this.MessageArraySize - 1] = eventFactory.createCommonBaseEvent();
    }

    protected void getLocalHostId() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? "IPV6" : "IPV4";
        }
        catch (Exception e) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = "None";
        }
        try {
            this.localHostName = InetAddress.getByName(this.localHostId).getHostName();
        }
        catch (Exception e) {
            this.localHostName = null;
        }
    }

    protected String getLocale() {
        String originLanguage = System.getProperty("user.language");
        String originRegion = System.getProperty("user.region");
        if (originLanguage != null && originRegion != null) {
            return originLanguage.concat("-").concat(originRegion);
        }
        return "";
    }

    protected boolean isNum(String line, int pos) {
        try {
            return Character.isDigit(line.charAt(pos));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isNum(String line, int pos, int num) {
        for (int i = 0; i < num; ++i) {
            if (this.isNum(line, pos + i)) continue;
            return false;
        }
        return true;
    }

    protected boolean isLet(String line, int pos) {
        try {
            return Character.isLetter(line.charAt(pos));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isLet(String line, int pos, int num) {
        for (int i = 0; i < num; ++i) {
            if (this.isLet(line, pos + i)) continue;
            return false;
        }
        return true;
    }

    protected boolean isChar(String line, int pos, char c) {
        try {
            return line.charAt(pos) == c;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void postParse() throws LogParserException {
        try {
            if (this.logFile != null) {
                this.logFile.close();
            }
        }
        catch (Exception e) {
            ParserUtilities.exceptionHandler(e, "");
        }
    }

    protected String readLine() {
        String msgLine = null;
        try {
            if (ParserConstants.IS_ZOS_PLATFORM) {
                int size = (int)(this.logFile.length() - this.logFile.getFilePointer()) + 1;
                byte[] buf = new byte[size];
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    byte a = (byte)this.logFile.read();
                    if (a == -1) {
                        j = -1;
                        break;
                    }
                    if (a == 21) break;
                    buf[i] = a;
                    ++j;
                }
                msgLine = j == -1 ? null : new String(buf, 0, j);
            } else {
                msgLine = this.logFile.readLine();
            }
            ++this.curLineNumber;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return msgLine;
    }

    protected static ExtendedDataElement createStringEDE(String name, String value) {
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(name);
        int valuesLength = 0;
        if (value != null && (valuesLength = value.trim().length()) > 1024) {
            extendedDataElement.setTypeAsInt(16);
            ArrayList<String> valuesParts = new ArrayList<String>();
            for (int counter = 0; counter < valuesLength; counter += 1024) {
                valuesParts.add(value.substring(counter, Math.min(counter + 1024, valuesLength)));
            }
            extendedDataElement.setValues(valuesParts.toArray(new String[valuesParts.size()]));
        } else {
            extendedDataElement.setTypeAsInt(7);
            extendedDataElement.setValues(new String[]{value});
        }
        return extendedDataElement;
    }
}

