/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestJavaUtil {
    public static InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite iTestSuite, boolean bl) {
        return new InvokedTestSelectionDialog(Display.getCurrent().getActiveShell(), iTestSuite, TestJavaPlugin.getString("DLG_INV_TST_TTL"), TestJavaPlugin.getString("DLG_LOCAL_TESTS_LBL"), TestJavaPlugin.getString("DLG_ALL_TESTS_LBL"), bl){

            protected void registerHelp(int n, Object object) {
                switch (n) {
                    case 1: {
                        WorkbenchHelp.setHelp((Control)((Control)object), (String)(TestJavaPlugin.getID() + ".itdg0001"));
                        break;
                    }
                    case 2: {
                        WorkbenchHelp.setHelp((Control)((Control)object), (String)(TestJavaPlugin.getID() + ".itdg0002"));
                        break;
                    }
                    case 3: {
                        WorkbenchHelp.setHelp((Control)((Control)object), (String)(TestJavaPlugin.getID() + ".itdg0003"));
                    }
                }
            }
        };
    }

    public static ElementTreeSelectionDialog createPackageDialog(Shell shell, final boolean bl) {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof IJavaProject) {
                    return true;
                }
                if (object2 instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object2;
                    if (iPackageFragmentRoot.isArchive()) {
                        return false;
                    }
                    return !iPackageFragmentRoot.isExternal();
                }
                if (!bl && object2 instanceof IPackageFragment) {
                    return !((IPackageFragment)object2).isDefaultPackage();
                }
                return false;
            }
        };
        StandardJavaElementContentProvider standardJavaElementContentProvider = new StandardJavaElementContentProvider(){
            private StructuredViewer structuredViewer;

            public void inputChanged(Viewer viewer, Object object, Object object2) {
                if (viewer != this.structuredViewer) {
                    this.structuredViewer = null;
                    if (viewer instanceof StructuredViewer) {
                        this.structuredViewer = (StructuredViewer)viewer;
                    }
                }
                super.inputChanged(viewer, object, object2);
            }

            public boolean hasChildren(Object object) {
                if (object instanceof IPackageFragment) {
                    return false;
                }
                try {
                    if (object instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)object).getChildren().length > 1;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                return super.hasChildren(object);
            }

            public Object[] getChildren(Object object) {
                try {
                    if (object instanceof IJavaModel) {
                        return 3.concatenate((Object[])this.getJavaProjects((IJavaModel)object), (Object[])this.getNonJavaProjects((IJavaModel)object));
                    }
                    return super.getChildren(object);
                }
                catch (JavaModelException javaModelException) {
                    TestJavaPlugin.logError(javaModelException);
                    return new Object[0];
                }
            }

            private Object[] getNonJavaProjects(IJavaModel iJavaModel) throws JavaModelException {
                return iJavaModel.getNonJavaResources();
            }
        };
        ISelectionStatusValidator iSelectionStatusValidator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                if (objectArray.length == 1 && objectArray[0] instanceof IPackageFragment) {
                    return new Status(0, TestJavaPlugin.getID(), 0, "", null);
                }
                return new Status(4, TestJavaPlugin.getID(), 0, "", null);
            }
        };
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)standardJavaElementContentProvider);
        elementTreeSelectionDialog.addFilter(viewerFilter);
        elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        elementTreeSelectionDialog.setValidator(iSelectionStatusValidator);
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setDoubleClickSelects(true);
        return elementTreeSelectionDialog;
    }

    public static ElementTreeSelectionDialog createSourceFolderDialog(Shell shell, IJavaProject iJavaProject) {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof IJavaProject) {
                    return true;
                }
                if (object2 instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object2;
                    if (iPackageFragmentRoot.isArchive()) {
                        return false;
                    }
                    return !iPackageFragmentRoot.isExternal();
                }
                return false;
            }
        };
        StandardJavaElementContentProvider standardJavaElementContentProvider = new StandardJavaElementContentProvider(){
            private StructuredViewer structuredViewer;

            public void inputChanged(Viewer viewer, Object object, Object object2) {
                if (viewer != this.structuredViewer) {
                    this.structuredViewer = null;
                    if (viewer instanceof StructuredViewer) {
                        this.structuredViewer = (StructuredViewer)viewer;
                    }
                }
                super.inputChanged(viewer, object, object2);
            }

            public boolean hasChildren(Object object) {
                if (object instanceof IJavaProject) {
                    return TestJavaUtil.hasSourceFolders((IJavaProject)object);
                }
                return super.hasChildren(object);
            }
        };
        ISelectionStatusValidator iSelectionStatusValidator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                if (objectArray.length == 1) {
                    if (objectArray[0] instanceof IPackageFragmentRoot) {
                        return new Status(0, TestJavaPlugin.getID(), 0, "", null);
                    }
                    if (objectArray[0] instanceof IJavaProject && !TestJavaUtil.hasSourceFolders((IJavaProject)objectArray[0])) {
                        return new Status(0, TestJavaPlugin.getID(), 0, "", null);
                    }
                }
                return new Status(4, TestJavaPlugin.getID(), 0, "", null);
            }
        };
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)standardJavaElementContentProvider);
        elementTreeSelectionDialog.addFilter(viewerFilter);
        elementTreeSelectionDialog.setValidator(iSelectionStatusValidator);
        if (iJavaProject != null) {
            elementTreeSelectionDialog.setInput((Object)iJavaProject);
        } else {
            elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        }
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setDoubleClickSelects(true);
        return elementTreeSelectionDialog;
    }

    public static IJavaProject[] getJavaProjects() {
        try {
            return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (Exception exception) {
            return new IJavaProject[0];
        }
    }

    public static boolean hasSourceFolders(IJavaProject iJavaProject) {
        IClasspathEntry[] iClasspathEntryArray = null;
        try {
            iClasspathEntryArray = iJavaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int n = iClasspathEntryArray.length;
        for (int i = 0; i < n; ++i) {
            if (iClasspathEntryArray[i].getEntryKind() != 3 || iJavaProject.getPath().equals(iClasspathEntryArray[i].getPath())) continue;
            return true;
        }
        return false;
    }

    public static List getSourceFolders(IJavaProject iJavaProject) {
        IClasspathEntry[] iClasspathEntryArray = null;
        try {
            iClasspathEntryArray = iJavaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        int n = iClasspathEntryArray.length;
        for (int i = 0; i < n; ++i) {
            IResource iResource;
            if (iClasspathEntryArray[i].getEntryKind() != 3 || iJavaProject.getPath().equals(iClasspathEntryArray[i].getPath()) || (iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iClasspathEntryArray[i].getPath())) == null || !iResource.exists() || iResource.getType() != 2) continue;
            arrayList.add(iResource);
        }
        return arrayList;
    }
}

