/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports.responsetime;

import org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider;

public class ResponseTimeData
implements IReportGraphDataProvider {
    private static int cumulativeCounter = 0;
    private static double cumulativeResponseTime = 0.0;
    String id = null;
    double responseTime = 0.0;
    long count = 0L;

    public ResponseTimeData(String string) {
        this.id = string;
    }

    public void addSample(long l) {
        this.responseTime += (double)l / 1000.0;
        cumulativeResponseTime += (double)l / 1000.0;
        ++this.count;
        ++cumulativeCounter;
    }

    public static void resetCumulativeValues() {
        cumulativeCounter = 0;
        cumulativeResponseTime = 0.0;
    }

    public String getId() {
        return this.id;
    }

    public double getAverageResponseTime() {
        if (this.count == 0L) {
            return 0.0;
        }
        return new Double(this.responseTime / (double)this.count);
    }

    public static String getOverallAvarageResponseTime() {
        return new Double(cumulativeResponseTime / new Long(cumulativeCounter).doubleValue()).toString();
    }

    public String getValue() {
        return new Double(this.getAverageResponseTime()).toString();
    }

    static class OverallResponseTime
    implements IReportGraphDataProvider {
        OverallResponseTime() {
        }

        public String getId() {
            return "Overall Average";
        }

        public String getValue() {
            return ResponseTimeData.getOverallAvarageResponseTime();
        }
    }
}

