/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.perfmon.PerfmonPlugin;

public class PerfmonCommandUtil {
    Agent agent;
    Process process;
    Node node;

    public PerfmonCommandUtil(Agent agent) throws InactiveProcessException {
        this.agent = agent;
        this.process = agent.getProcess();
        this.node = this.process.getNode();
    }

    public void setFrequency(int freq) throws IOException {
        this.setNVPair("var_int", "DC_WAITTIME", "" + freq);
    }

    public void getUpdatedTree() throws IOException {
        this.setNVPair("updatetree", "", "true");
    }

    public void getUpdatedTree(SDDescriptor update) throws IOException {
        if (update.getId() == null) {
            return;
        }
        PerfmonPlugin.DBG.info("Requesting tree update for descriptor " + update.getName() + " (" + update.getId() + ")");
        this.setNVPair("updatetree", update.getId(), "true");
    }

    public void stopTracing(SDDescriptor counter) throws IOException, NullPointerException {
        this.applyDown(counter, false);
        this.applyUp(counter, false);
    }

    public void startTracing(SDDescriptor counter) throws IOException, NullPointerException {
        this.applyDown(counter, true);
        this.applyUp(counter, true);
    }

    private void apply(SDDescriptor descriptor, boolean on) throws IOException {
        this.traceCounter(descriptor, on);
    }

    private void applyUp(SDDescriptor descriptor, boolean on) throws IOException {
        SDDescriptor parent = descriptor.getParent();
        if (parent != null) {
            this.apply(parent, on);
            this.applyUp(parent, on);
        }
    }

    private void applyDown(SDDescriptor descriptor, boolean on) throws IOException {
        this.apply(descriptor, on);
        EList children = descriptor.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.applyDown((SDDescriptor)children.get(i), on);
        }
    }

    private void traceCounter(SDDescriptor counter, boolean on) throws IOException, NullPointerException {
        String id = counter.getId();
        if (id == null) {
            throw new NullPointerException("descriptor ID not found");
        }
        this.setNVPair("filter", id, "" + on);
    }

    public void setNVPair(String type, String name, String value) throws IOException {
        ControlMessage message = new ControlMessage();
        SetNVPairCommand command = new SetNVPairCommand();
        try {
            command.setProcessId(Long.parseLong(this.process.getProcessId()));
        }
        catch (InactiveProcessException e) {
            throw new IOException("Inactive process - try again soon?");
        }
        command.setAgentName(this.agent.getName());
        command.setType(type);
        command.setName(name);
        command.setValue(value);
        message.appendCommand((CommandElement)command);
        this.node.getConnection().sendMessage(message, null);
    }
}

