/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEvaluatorExt;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;
import org.eclipse.hyades.models.common.datapool.impl.Messages;
import org.eclipse.hyades.models.common.util.DatapoolUtil;
import org.eclipse.hyades.models.common.util.XMLParserUtil;
import org.w3c.dom.Document;

public class DPLCellImpl
extends EObjectImpl
implements DPLCell {
    public static final String copyright = "";
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected DPLVariable variable = null;
    private static final String XML_AMPERSAND = "&amp;";
    private static final String AMPERSAND = "&";
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";

    protected DPLCellImpl() {
    }

    protected EClass eStaticClass() {
        return Common_DatapoolPackage.eINSTANCE.getDPLCell();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldValue, (Object)this.value));
        }
    }

    public DPLVariable getVariable() {
        if (this.variable != null && this.variable.eIsProxy()) {
            DPLVariable oldVariable = this.variable;
            this.variable = (DPLVariable)this.eResolveProxy((InternalEObject)this.variable);
            if (this.variable != oldVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldVariable, (Object)this.variable));
            }
        }
        return this.variable;
    }

    public DPLVariable basicGetVariable() {
        return this.variable;
    }

    public void setVariable(DPLVariable newVariable) {
        DPLVariable oldVariable = this.variable;
        this.variable = newVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldVariable, (Object)this.variable));
        }
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getValue();
            }
            case 1: {
                if (resolve) {
                    return this.getVariable();
                }
                return this.basicGetVariable();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setValue((String)newValue);
                return;
            }
            case 1: {
                this.setVariable((DPLVariable)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setVariable((DPLVariable)null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 1: {
                return this.variable != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public void setVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable) {
        this.setVariable((DPLVariable)variable);
    }

    public String getPersistedRepresentation() {
        if (this.getValue() != null) {
            return this.getValue();
        }
        return this.wrapAsLiteral(new String());
    }

    public IDatapoolVariable getCellVariable() {
        return this.getVariable();
    }

    public IDatapoolRecord getCellRecord() {
        return (IDatapoolRecord)this.eContainer();
    }

    public Object getCellValue() {
        if (this.getValue() == null) {
            return null;
        }
        String internalValue = this.getValue();
        internalValue = internalValue.replaceAll(AMPERSAND, XML_AMPERSAND);
        String tag = null;
        String val = null;
        try {
            Document doc = XMLParserUtil.parse(internalValue);
            tag = doc.getFirstChild().getNodeName();
            DPLLogImpl.log("Tag: " + tag);
            val = doc.getFirstChild().getFirstChild().getNodeValue();
            DPLLogImpl.log("Val: " + val);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            IDatapoolEvaluatorExt evaluator = DatapoolUtil.findDatapoolEvaluator(tag);
            if (evaluator != null) {
                return evaluator.evaluate(val);
            }
            if (tag != null && tag.equals("Literal")) {
                String wrappedValue = this.getValue();
                String value = this.unwrapLiteral(wrappedValue);
                return value;
            }
        }
        catch (Exception e) {
            DPLLogImpl.log(e.getMessage());
        }
        return this.getValue();
    }

    public String getStringValue() {
        Object cellValue = this.getCellValue();
        if (cellValue != null) {
            return cellValue.toString();
        }
        return new String();
    }

    public long getLongValue() {
        return Long.parseLong((String)this.getCellValue());
    }

    public int getIntValue() {
        return Integer.parseInt((String)this.getCellValue());
    }

    public short getShortValue() {
        return Short.parseShort((String)this.getCellValue());
    }

    public byte getByteValue() {
        return Byte.parseByte((String)this.getCellValue());
    }

    public double getDoubleValue() {
        return Double.parseDouble((String)this.getCellValue());
    }

    public float getFloatValue() {
        return Float.parseFloat((String)this.getCellValue());
    }

    public boolean getBooleanValue() {
        return Boolean.getBoolean((String)this.getCellValue());
    }

    public char getCharValue() {
        return ((String)this.getCellValue()).charAt(0);
    }

    public void setPersistedRepresentation(String value) {
        this.setValue(value);
    }

    public void setCellValue(Object value) {
        if (value == null) {
            this.setValue((String)value);
            return;
        }
        String tag = null;
        String val = null;
        if (value.toString().indexOf("<") != -1) {
            try {
                Document doc = XMLParserUtil.parse(value.toString());
                tag = doc.getFirstChild().getNodeName();
                val = doc.getFirstChild().getFirstChild().getNodeValue();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            IDatapoolEvaluatorExt evaluator;
            if (tag != null && val != null && (evaluator = DatapoolUtil.findDatapoolEvaluator(tag)) != null) {
                this.setValue(value.toString());
                return;
            }
            throw new DatapoolException(Messages.getString("DPLCellImpl.18") + tag);
        }
        catch (Throwable t) {
            String stringValue = value.toString();
            int index = stringValue.indexOf(START_LITERAL);
            if (index == -1) {
                String wrappedValue = this.wrapAsLiteral(value.toString());
                this.setValue(wrappedValue);
                return;
            }
            this.setValue(stringValue);
            return;
        }
    }

    public Object getClonedCellValue() {
        return this.getCellValue();
    }

    private String wrapAsLiteral(String text) {
        if (text != null) {
            return START_LITERAL + text + END_LITERAL;
        }
        return "<Literal></Literal>";
    }

    private String unwrapLiteral(String text) {
        if ((text = text.trim()).startsWith(START_LITERAL) && text.endsWith(END_LITERAL)) {
            text = text.substring(START_LITERAL.length(), text.length());
            int endIndex = text.lastIndexOf(END_LITERAL);
            text = text.substring(0, endIndex);
            return text;
        }
        return new String();
    }
}

