/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TOSEntryPointCaller;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class TOSEntryPoint {
    private StkEntry _stkEntry = null;
    protected Vector _threads = null;
    protected Vector _callers = null;

    public TOSEntryPoint(StkEntry stkEntry) {
        this._stkEntry = stkEntry;
        this._threads = new Vector();
        this._callers = new Vector();
    }

    String getName() {
        String sName = null;
        if (this._stkEntry != null) {
            sName = this._stkEntry.getFQName();
        }
        return sName;
    }

    public int numThreads() {
        return this._threads.size();
    }

    public int numCallers() {
        return this._callers.size();
    }

    public void addThread(Thd thd) {
        this._threads.add(thd);
    }

    public Enumeration getThreadEnum() {
        Enumeration e = this._threads.elements();
        return e;
    }

    public Thd getNextThread(Enumeration e) {
        Thd tRet = null;
        if (e.hasMoreElements()) {
            tRet = (Thd)e.nextElement();
        }
        return tRet;
    }

    public void addCaller(TOSEntryPointCaller caller) {
        this._callers.add(caller);
    }

    public Enumeration getCallerEnum() {
        return this._callers.elements();
    }

    public TOSEntryPointCaller getNextCaller(Enumeration e) {
        TOSEntryPointCaller tRet = null;
        if (e.hasMoreElements()) {
            tRet = (TOSEntryPointCaller)e.nextElement();
        }
        return tRet;
    }

    public void addThreadsNoDups(Vector thds) {
        for (int i = 0; i < thds.size(); ++i) {
            Thd thd = (Thd)thds.elementAt(i);
            boolean found = false;
            for (int j = 0; j < this._threads.size(); ++j) {
                Thd chkThd = (Thd)this._threads.elementAt(j);
                if (!chkThd.equals(thd)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this._threads.add(thd);
        }
    }

    private TOSEntryPoint() {
    }
}

