/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.processes;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;

public class TestExecutionProcess
implements IProcess {
    private IExecutor executor;
    private ILaunch launch;
    private boolean terminated = false;
    private TPFTest test;
    private TPFExecutionResult executionResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestExecutionProcess(IExecutor executor, ILaunch launch) throws CoreException {
        ExecutorStub exStub;
        this.executor = executor;
        this.launch = launch;
        this.test = TestLaunchConfigurationFacade.getTest(launch.getLaunchConfiguration());
        IExecutor iExecutor = executor;
        synchronized (iExecutor) {
            if (executor.getState() == 4) {
                this.onTerminate();
            } else {
                this.executor.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

                    public void stateChanged(ExecutionComponentStateChangeEvent newState) {
                        TestExecutionProcess.this.onTerminate();
                    }
                });
            }
            this.setupExecutorStateMonitoring(executor);
        }
        if (executor instanceof ExecutorStub && (exStub = (ExecutorStub)executor).getDataProcessors().length > 0) {
            IDataProcessor dataProcessor = exStub.getDataProcessors()[0];
            this.executionResult = this.getExecutionResult(dataProcessor);
        }
    }

    private void setupExecutorStateMonitoring(IExecutor executor) {
        IExecutionHarnessDataProcessor dp;
        Agent controlAgent;
        ExecutorStub es;
        IDataProcessor[] dataProcessors;
        if (executor != null && executor instanceof ExecutorStub && (dataProcessors = (es = (ExecutorStub)executor).getDataProcessors()).length > 0 && dataProcessors[0] instanceof IExecutionHarnessDataProcessor && (controlAgent = (dp = (IExecutionHarnessDataProcessor)dataProcessors[0]).getControlAgent()) != null) {
            class ControlAgentListener
            implements AgentListener {
                ControlAgentListener() {
                }

                public void agentActive(Agent agent) {
                }

                public void agentInactive(Agent agent) {
                    TestExecutionProcess.this.onTerminate();
                }

                public void error(Agent agent, String errorId, String errorMessage) {
                    System.out.println("Error from tester agent: id=" + errorId + ", " + errorMessage);
                }

                public void handleCommand(Agent agent, CommandElement command) {
                }
            }
            controlAgent.addAgentListener((AgentListener)new ControlAgentListener());
        }
    }

    public String getLabel() {
        return TestUIPlugin.getString("TestExecutionProcess.testProcess") + " [" + this.test.getName() + "]";
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() {
        return 0;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean canTerminate() {
        return this.executionResult != null;
    }

    public synchronized boolean isTerminated() {
        return this.terminated || this.executor.getState() == 4;
    }

    public void terminate() throws DebugException {
        TestExecutionHarness teh = new TestExecutionHarness();
        String errorMessage = teh.stopTest(this.executor, this.executionResult);
        if (errorMessage != null) {
            Status status = new Status(4, TestUIPlugin.getID(), 0, errorMessage, null);
            throw new DebugException((IStatus)status);
        }
    }

    protected synchronized void onTerminate() {
        if (!this.terminated) {
            IRunHandler runHandler = LaunchConfigurationExtensionsManager.getInstance().getRunHandler(this.test);
            if (runHandler != null) {
                runHandler.postRun(this.launch);
            }
            this.terminated = true;
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        }
    }

    private TPFExecutionResult getExecutionResult(IDataProcessor dataProcessor) {
        XMLExecutionDataProcessor dp;
        ExecutionContext ec;
        if (dataProcessor instanceof XMLExecutionDataProcessor && (ec = (ExecutionContext)(dp = (XMLExecutionDataProcessor)dataProcessor).getContext().getCustomData().get(ExecutionContext.root)) != null) {
            Resource res = ec.getResource();
            Iterator it = res.getContents().iterator();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof TPFExecutionResult)) continue;
                return (TPFExecutionResult)obj;
            }
        }
        return null;
    }

    public TPFExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public IExecutor getExecutor() {
        return this.executor;
    }
}

