/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorFilter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.ExecutionEditorPart;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ResourceUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.TestNavigatorProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorFrameSource;
import org.eclipse.hyades.test.ui.internal.navigator.TestResourceChangeUpdater;
import org.eclipse.hyades.test.ui.internal.navigator.action.TestNavigatorActionGroup;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TestNavigator
extends TreeNavigator
implements ISelectionListener {
    public static final String ID = "org.eclipse.hyades.test.ui.TestNavigator";
    private static Map testNavigatorByWorkbenchWindow;
    protected static final String SET_SHOW_FOLDERS = "SHOW_FOLDERS";
    protected static final String SET_SHOW_EOBJECT_CHILDREN = "SHOW_EOBJECT_CHILDREN";
    protected static final String SET_SORTER_CRITERIA = "SORTER_CRITERIA";
    protected static final int CP_FOLDER = 0;
    protected static final int CP_LOGICAL = 1;
    private List rootLogicalFolders;
    private boolean showingFolders = true;
    private boolean showingEObjectChildren = true;
    private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
    private TestNavigatorProvider provider;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;

    private static void addTestNavigator(TestNavigator testNavigator) {
        if (testNavigatorByWorkbenchWindow == null) {
            testNavigatorByWorkbenchWindow = new HashMap();
        }
        testNavigatorByWorkbenchWindow.put(testNavigator.getSite().getWorkbenchWindow(), testNavigator);
    }

    private static void removeTestNavigator(TestNavigator testNavigator) {
        if (testNavigatorByWorkbenchWindow != null) {
            testNavigatorByWorkbenchWindow.remove(testNavigator.getSite().getWorkbenchWindow());
            if (testNavigatorByWorkbenchWindow.isEmpty()) {
                testNavigatorByWorkbenchWindow = null;
            }
        }
    }

    public static TestNavigator getTestNavigator(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow != null && testNavigatorByWorkbenchWindow != null) {
            return (TestNavigator)((Object)testNavigatorByWorkbenchWindow.get(workbenchWindow));
        }
        return null;
    }

    public TestNavigator() {
        super(ID);
        this.initExtension();
    }

    private void initExtension() {
        int i;
        IConfigurationElement[] members;
        this.provider = new TestNavigatorProvider();
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorFile");
        if (extPoint != null) {
            members = extPoint.getConfigurationElements();
            for (i = 0; i < members.length; ++i) {
                if (members[i].getName() == null) continue;
                String extName = members[i].getAttribute("targetExtension");
                try {
                    IConfigurationElement[] conv;
                    IHyadesTestNavigatorProvider delegatedProvider = null;
                    IHyadesTestNavigatorConverter converter = null;
                    IConfigurationElement[] prov = members[i].getChildren("provider");
                    if (prov.length != 0) {
                        delegatedProvider = (IHyadesTestNavigatorProvider)prov[0].createExecutableExtension("class");
                    }
                    if ((conv = members[i].getChildren("converter")).length != 0) {
                        converter = (IHyadesTestNavigatorConverter)conv[0].createExecutableExtension("class");
                    }
                    this.provider.addVisibleFile(extName, delegatedProvider, converter);
                    continue;
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                }
            }
        }
        if ((extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorObject")) != null) {
            members = extPoint.getConfigurationElements();
            for (int i2 = 0; i2 < members.length; ++i2) {
                if (members[i2].getName() == null) continue;
                String objectName = members[i2].getAttribute("targetObject");
                try {
                    IHyadesTestNavigatorProvider delegatedProvider = (IHyadesTestNavigatorProvider)members[i2].createExecutableExtension("provider");
                    this.provider.addVisibleObject(objectName, delegatedProvider);
                    continue;
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                }
            }
        }
        if ((extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorFilter")) != null) {
            members = extPoint.getConfigurationElements();
            for (i = 0; i < members.length; ++i) {
                if (members[i].getName() == null) continue;
                try {
                    IHyadesTestNavigatorFilter filter = (IHyadesTestNavigatorFilter)members[i].createExecutableExtension("class");
                    this.provider.addFilter(filter);
                    continue;
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                }
            }
        }
    }

    public void dispose() {
        if (this.rootLogicalFolders != null) {
            this.rootLogicalFolders.clear();
        }
        TestNavigator.removeTestNavigator(this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        this.resourceChangeUpdaterProvider.getResourceChangeUpdater().dispose();
        this.resourceChangeUpdaterProvider.dispose();
        this.resourceChangeUpdaterProvider = null;
        this.provider.dispose();
        this.provider = null;
        super.dispose();
    }

    public String getStoreSection() {
        return "TestNavigator";
    }

    protected void initSettings() {
        this.setShowingFolders(true);
        this.setShowingEObjectChildren(false);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        TestNavigator.addTestNavigator(this);
    }

    public IFile getFile(Object object) {
        IFile file;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof Resource) {
            return EMFUtil.getWorkspaceFile((Resource)object);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eContainer() != null) {
                return null;
            }
            Resource resource = eObject.eResource();
            if (resource == null) {
                return null;
            }
            return EMFUtil.getWorkspaceFile(resource);
        }
        if (object instanceof IAdaptable && (file = (IFile)((IAdaptable)object).getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = TestNavigator.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile)) != null) {
            return file;
        }
        return null;
    }

    public void setMonitoringResourceChange(boolean enabled) {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().setActive(enabled);
        }
    }

    public boolean isMonitoringResourceChange() {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().isActive();
        }
        return false;
    }

    protected void loadSettings() {
        super.loadSettings();
        this.setShowingEObjectChildren(this.getSettings().getBoolean(SET_SHOW_EOBJECT_CHILDREN));
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        int criteria = 1;
        try {
            criteria = this.getSettings().getInt(SET_SORTER_CRITERIA);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        NavigatorViewerSorter viewerSorter = new NavigatorViewerSorter((INavigator)this, criteria){

            protected String getValue(Viewer viewer, Object e) {
                String value = super.getValue(viewer, e);
                if (e instanceof EObject) {
                    EObject eObject = (EObject)e;
                    if (eObject.eContainer() != null) {
                        return "";
                    }
                    if (this.getCriteria() == 2) {
                        if (eObject instanceof TPFTest) {
                            String type = ((TPFTest)eObject).getType();
                            value = type != null ? type + value : "zZz" + type;
                        }
                        value = eObject.eClass().getName() + value;
                    }
                }
                return value;
            }
        };
        treeViewer.setSorter((ViewerSorter)viewerSorter);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!TestNavigator.this.isShowingEObjectChildren()) {
                    return !(parentElement instanceof EObject);
                }
                return true;
            }
        };
        treeViewer.addFilter(viewerFilter);
        this.resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider, 1);
        TestResourceChangeUpdater resourceChangeUpdater = new TestResourceChangeUpdater(this);
        this.resourceChangeUpdaterProvider.setResourceChangeUpdater((IResourceChangeUpdater)resourceChangeUpdater);
        treeViewer.setContentProvider((IContentProvider)this.provider);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.provider, decorator));
    }

    protected boolean editorActivated(IEditorPart editor) {
        IFileEditorInput fileInput;
        IFile file;
        Resource resource;
        if (this.getViewer() == null) {
            return false;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (resource = EMFUtil.getResource(null, file = (fileInput = (IFileEditorInput)input).getFile())) != null && !resource.getContents().isEmpty()) {
            Object currentSelection;
            IStructuredSelection structuredSelection = this.getStructuredSelection();
            if (structuredSelection.size() == 1 && (currentSelection = structuredSelection.getFirstElement()) instanceof EObject && ((EObject)currentSelection).eResource() == resource) {
                return true;
            }
            this.selectReveal((ISelection)new StructuredSelection(resource.getContents().get(0)));
            return true;
        }
        return false;
    }

    protected void linkToEditor(IStructuredSelection structuredSelection) {
        IWorkbenchPage page;
        IEditorPart editor;
        IFile file = this.getFile(structuredSelection.getFirstElement());
        if (file != null && (editor = (page = this.getSite().getPage()).findEditor((IEditorInput)new FileEditorInput(file))) != null) {
            page.bringToTop((IWorkbenchPart)editor);
            return;
        }
    }

    public AbstractUIPlugin getPlugin() {
        return TestUIPlugin.getInstance();
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void createActions() {
        this.setActionGroup(new TestNavigatorActionGroup(this));
    }

    public boolean isShowingFolders() {
        return this.showingFolders;
    }

    public void setShowingFolders(boolean enabled) {
        this.showingFolders = enabled;
        this.getSettings().put(SET_SHOW_FOLDERS, this.showingFolders);
        if (this.getViewer() == null) {
            return;
        }
        this.getViewer().refresh();
    }

    public boolean isShowingEObjectChildren() {
        return this.showingEObjectChildren;
    }

    public void setShowingEObjectChildren(boolean enabled) {
    }

    protected String getStatusLineMessage(IStructuredSelection structuredSelection) {
        if (structuredSelection.size() == 1) {
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof IResource) {
                return ((IResource)selection).getFullPath().toString();
            }
            if (selection instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)selection;
                if (logicalFolder.getChildren().size() == 0) {
                    return logicalFolder.getName();
                }
                return TestUIPlugin.getString("STS_LNE_LOG_FLD", new String[]{logicalFolder.getName(), Integer.toString(logicalFolder.getChildren().size())});
            }
            if (selection instanceof CMNNamedElement) {
                CMNNamedElement namedElement = (CMNNamedElement)selection;
                String label = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)namedElement);
                IFile file = EMFUtil.getWorkspaceFile((EObject)namedElement);
                String filePath = "";
                if (file != null) {
                    filePath = file.getFullPath().toString();
                }
                return TestUIPlugin.getString("STS_LNE_FILE_ELEM", new String[]{label, filePath});
            }
            if (selection instanceof Resource) {
                Resource resource = (Resource)selection;
                String label = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)resource);
                IFile file = EMFUtil.getWorkspaceFile(resource);
                String filePath = "";
                if (file != null) {
                    filePath = file.getFullPath().toString();
                }
                return TestUIPlugin.getString("STS_LNE_FILE_ELEM", new String[]{label, filePath});
            }
        }
        return super.getStatusLineMessage(structuredSelection);
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getViewer() == this.getTreeViewer()) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (element instanceof EObject || element instanceof Resource) {
                return;
            }
            TreeViewer treeViewer = this.getTreeViewer();
            if (treeViewer.isExpandable(element)) {
                treeViewer.setExpandedState(element, !treeViewer.getExpandedState(element));
            }
        }
    }

    protected IStructuredSelection convertToViewer(ISelection selection) {
        IStructuredSelection structuredSelection = super.convertToViewer(selection);
        if (structuredSelection.isEmpty()) {
            return structuredSelection;
        }
        ArrayList<Object> elements = new ArrayList<Object>(structuredSelection.size());
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof IFile) {
                EObject[] eObjects = EMFUtil.getEObjects(null, (IFile)object);
                int maxj = eObjects.length;
                for (int j = 0; j < maxj; ++j) {
                    if (!(eObjects[j] instanceof CMNNamedElement)) continue;
                    elements.add(eObjects[j]);
                }
                continue;
            }
            if (object instanceof EObject) {
                EObject eObject = EMFUtil.getEObject(null, (EObject)object, false);
                if (eObject == null) continue;
                if (eObject.eContainer() == null) {
                    elements.add(eObject);
                    continue;
                }
                if (this.isShowingEObjectChildren()) {
                    elements.add(eObject);
                    continue;
                }
                elements.add(EcoreUtil.getRootContainer((EObject)eObject));
                continue;
            }
            elements.add(object);
        }
        return new StructuredSelection(elements);
    }

    public void handleChange(int type) {
        if (NavigatorViewerSorter.SORTER_TYPE == type) {
            this.getSettings().put(SET_SORTER_CRITERIA, ((NavigatorViewerSorter)this.getViewer().getSorter()).getCriteria());
            NavigatorActionGroup actionGroup = this.getActionGroup();
            if (actionGroup != null) {
                actionGroup.updateActionBars();
            }
        }
        super.handleChange(type);
    }

    public Object getInitialViewerInput() {
        return super.getInitialViewerInput();
    }

    protected TreeNavigatorFrameSource createFrameSource() {
        return new TestNavigatorFrameSource(this);
    }

    public void registerRootLogcalFolder(LogicalFolder logicalFolder) {
        if (logicalFolder != null && logicalFolder.getParent() == null) {
            if (this.rootLogicalFolders == null) {
                this.rootLogicalFolders = new ArrayList();
            }
            this.rootLogicalFolders.add(logicalFolder);
        }
    }

    public LogicalFolder getRootLogicalFolder(String name) {
        if (this.rootLogicalFolders != null && name != null) {
            Iterator i = this.rootLogicalFolders.iterator();
            while (i.hasNext()) {
                LogicalFolder logicalFolder = (LogicalFolder)i.next();
                if (!name.equals(logicalFolder.getName())) continue;
                return logicalFolder;
            }
        }
        return null;
    }

    protected List loadElements(IMemento memento) {
        Object[] objects = super.loadElements(memento).toArray();
        ArrayList<Object> elements = new ArrayList<Object>(objects.length);
        int maxi = objects.length;
        for (int i = 0; i < maxi; ++i) {
            if (objects[i] instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)objects[i];
                Object parent = logicalFolder.getParent();
                if (parent == null) {
                    if ((logicalFolder = this.getRootLogicalFolder(logicalFolder.getName())) == null) continue;
                    elements.add(logicalFolder);
                    continue;
                }
                if (parent instanceof EObject) {
                    EObject eObject = EMFUtil.getEObject(null, (EObject)parent, true);
                    if (eObject == null) continue;
                    LogicalFolder newLogicalFolder = new LogicalFolder((Object)eObject, logicalFolder.getName());
                    newLogicalFolder.setData(logicalFolder.getData());
                    newLogicalFolder.setDescription(logicalFolder.getDescription());
                    elements.add(newLogicalFolder);
                    continue;
                }
                elements.add(logicalFolder);
                continue;
            }
            if (objects[i] instanceof EObject) {
                EObject eObject = EMFUtil.getEObject(null, (EObject)objects[i], true);
                if (eObject == null) continue;
                elements.add(eObject);
                continue;
            }
            if (objects[i] instanceof ResourceUtil.ResourceAdaptable) {
                Resource resource = ((ResourceUtil.ResourceAdaptable)objects[i]).getResource();
                if (resource == null || (resource = EMFUtil.getResource(null, resource.getURI(), true)) == null) continue;
                elements.add(resource);
                continue;
            }
            elements.add(objects[i]);
        }
        return elements;
    }

    protected String getHelpContextId() {
        return TestUIPlugin.getID() + ".tnav0001";
    }

    public String[] getVisibleFiles() {
        return this.provider.getVisibleFiles();
    }

    public String getID() {
        return ID;
    }

    public boolean isVisibleResource(IResource resource) {
        return this.provider.isVisibleResource(resource);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof ExecutionEditorPart) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return;
            }
            Object element = structuredSelection.getFirstElement();
            if (!(element instanceof TPFExecutionResult)) {
                return;
            }
            TreeViewer treeViewer = this.getTreeViewer();
            if (treeViewer == null) {
                return;
            }
            URI uri = this.getObjectURI(structuredSelection.getFirstElement());
            if (uri == null) {
                return;
            }
            EObject obj2Select = null;
            ResourceSet resSet = EMFUtil.getResourceSet();
            Resource res = resSet.getResource(uri.trimFragment(), false);
            if (res != null) {
                String id = uri.fragment();
                TreeIterator i = res.getAllContents();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    if (!id.equals(EcoreUtil.getID((EObject)eObject)) || !(eObject instanceof TPFExecutionResult)) continue;
                    obj2Select = eObject;
                }
            }
            if (obj2Select == null) {
                return;
            }
            treeViewer.setSelection((ISelection)new StructuredSelection(obj2Select));
        }
    }

    protected URI getObjectURI(Object object) {
        EObject eObject;
        if (object != null && object instanceof EObject && (eObject = (EObject)object).eResource() != null) {
            return eObject.eResource().getURI().appendFragment(eObject.eResource().getURIFragment(eObject));
        }
        return null;
    }

    public Object getCorrespondingObjectFromFile(IResource resource) {
        return this.provider.getCorrespondingObjectFromFile(resource);
    }

    public void cleanConvertedObjectEntryFor(IResource resource) {
        this.provider.cleanConvertedObjectEntryFor(resource);
    }

    public Object getConvertedObjectFromFile(IResource resource) {
        IHyadesTestNavigatorConverter converter = this.provider.getConverterFromFile((IFile)resource);
        if (converter != null) {
            Object convertedObject = converter.getObjectFromResource(resource);
            this.provider.addCorrespondingObjectFromFile(resource, convertedObject);
            return convertedObject;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

