/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class AttributeWizardPage
extends WizardPage
implements Listener {
    public static final int EVENT_BEFORE_ACTIVATION = 3;
    private Text itemNameText;
    private Text itemDescriptionText;
    private String itemName;
    private String itemDescription;
    private Collection activationListeners = new ArrayList();
    private boolean firstActivation = true;

    public AttributeWizardPage(String pageName) {
        super(pageName);
    }

    public void dispose() {
        this.activationListeners.clear();
        super.dispose();
    }

    public void addActivationListener(Listener activationListener) {
        this.activationListeners.add(activationListener);
    }

    public void removeActivationListener(Listener activationListener) {
        this.activationListeners.remove(activationListener);
    }

    public void removeAllActivationListeners() {
        this.activationListeners.clear();
    }

    protected void invokeActivationListeners(int eventType) {
        Iterator i = this.activationListeners.iterator();
        while (i.hasNext()) {
            Event e = new Event();
            e.data = this;
            e.type = eventType;
            Listener listener = (Listener)i.next();
            listener.handleEvent(e);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        Label label = new Label(composite, 0);
        label.setText(HyadesUIPlugin.getString("LBL_NAME"));
        this.itemNameText = new Text(composite, 2048);
        this.itemNameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        if (this.itemName != null) {
            this.itemNameText.setText(this.itemName);
            this.itemNameText.selectAll();
        }
        this.addControl(composite);
        label = new Label(composite, 0);
        label.setText(HyadesUIPlugin.getString("LBL_DESC"));
        this.itemDescriptionText = new Text(composite, 2050);
        this.itemDescriptionText.setLayoutData((Object)GridDataUtil.createFill());
        if (this.itemDescription != null) {
            this.itemDescriptionText.setText(this.itemDescription);
        }
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)(HyadesUIPlugin.getID() + ".awip0001"));
        WorkbenchHelp.setHelp((Control)this.itemNameText, (String)(HyadesUIPlugin.getID() + ".awip0002"));
        WorkbenchHelp.setHelp((Control)this.itemDescriptionText, (String)(HyadesUIPlugin.getID() + ".awip0003"));
    }

    protected void addControl(Composite parent) {
    }

    public void handleEvent(Event event) {
        if (event.type == 24) {
            if (event.widget == this.itemNameText) {
                this.itemName = this.itemNameText.getText();
                this.setPageComplete(this.validatePage());
            } else if (event.widget == this.itemDescriptionText) {
                this.itemDescription = this.itemDescriptionText.getText();
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.invokeActivationListeners(3);
        }
        super.setVisible(visible);
        if (visible && this.firstActivation) {
            this.itemNameText.setFocus();
            this.firstActivation = false;
            this.itemNameText.setFocus();
            this.itemNameText.addListener(24, (Listener)this);
            this.setPageComplete(this.validatePage());
            this.setErrorMessage(null);
        }
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        if (this.firstActivation) {
            return true;
        }
        if (this.itemNameText.getText() == null || this.itemNameText.getText().trim().length() == 0) {
            this.setErrorMessage(HyadesUIPlugin.getString("_ERROR_MIS_NAME"));
            return false;
        }
        return true;
    }

    public void setItemName(String name) {
        if (this.itemNameText == null || this.itemNameText.isDisposed()) {
            this.itemName = name;
        } else {
            this.itemNameText.setText(name);
            this.itemNameText.selectAll();
        }
    }

    public String getItemName() {
        if (this.itemNameText == null || this.itemNameText.isDisposed()) {
            return this.itemName;
        }
        return this.itemNameText.getText();
    }

    public void setItemDescription(String description) {
        if (this.itemDescriptionText == null || this.itemDescriptionText.isDisposed()) {
            this.itemDescription = description;
        } else {
            this.itemDescriptionText.setText(description);
        }
    }

    public String getItemDescription() {
        if (this.itemDescriptionText == null || this.itemDescriptionText.isDisposed()) {
            return this.itemDescription;
        }
        return this.itemDescriptionText.getText();
    }
}

