/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DocumentRoot;
import org.eclipse.hyades.models.internal.probekit.Fragment;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.models.internal.probekit.Import;
import org.eclipse.hyades.models.internal.probekit.Label;
import org.eclipse.hyades.models.internal.probekit.Name;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.StaticField;
import org.eclipse.hyades.models.internal.probekit.Target;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitCompileProblemException;
import org.eclipse.hyades.probekit.ProbekitException;
import org.eclipse.hyades.probekit.ProbekitPlugin;

public class Compiler
implements IProbeCompiler {
    private static final String EMPTY_STRING = "";
    private static final String SPACE_STRING = " ";
    static final String[] primitiveTypes = new String[]{"int", "long", "char", "short", "byte", "boolean", "float", "double"};
    private List probekits = new LinkedList();
    private int compilerState = 0;
    private static final int STATE_DIRTY = 0;
    private static final int STATE_CLEAN = 1;
    private static final int STATE_ERROR = 2;
    private StringBuffer generatedSource;
    private StringBuffer engScript;
    private static final String lineSeparator = System.getProperty("line.separator");
    private String classPrefix = "";
    private String packageName = null;
    private static FragmentDescriptor[] fragmentDescriptors = new FragmentDescriptor[]{new FragmentDescriptor("entry", "ONENTRY", new boolean[]{false, false, true, true, true, true, true, false, true, true, true, true, true, false}), new FragmentDescriptor("exit", "ONEXIT", new boolean[]{true, true, true, true, true, true, true, false, true, true, true, true, true, false}), new FragmentDescriptor("catch", "ONCATCH", new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true}), new FragmentDescriptor("beforeCall", "BEFORECALL", new boolean[]{false, false, true, true, true, true, true, false, false, false, false, false, false, false}), new FragmentDescriptor("afterCall", "AFTERCALL", new boolean[]{true, true, true, true, true, true, true, false, false, false, false, false, false, false}), new FragmentDescriptor("staticInitializer", "STATICINITIALIZER", new boolean[]{false, false, true, true, true, false, false, false, true, true, true, true, true, false}), new FragmentDescriptor("executableUnit", "EXECUTABLEUNIT", new boolean[]{false, false, true, true, true, true, true, false, true, true, true, true, true, true})};
    private static DataItemDesc[] dataItemDescs = new DataItemDesc[]{new DataItemDesc("returnedObject", "Object", "Ljava/lang/Object;"), new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;"), new DataItemDesc("className", "String", "Ljava/lang/String;"), new DataItemDesc("methodName", "String", "Ljava/lang/String;"), new DataItemDesc("methodSig", "String", "Ljava/lang/String;"), new DataItemDesc("thisObject", "Object", "Ljava/lang/Object;"), new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;"), new DataItemDesc("isFinally", "boolean", "Z"), new DataItemDesc("staticField", "", ""), new DataItemDesc("classSourceFile", "String", "Ljava/lang/String;"), new DataItemDesc("methodNames", "String", "Ljava/lang/String;"), new DataItemDesc("methodLineTables", "String", "Ljava/lang/String;"), new DataItemDesc("methodNumber", "int", "I"), new DataItemDesc("executableUnitNumber", "int", "I")};
    static final String PROBE_INNER_CLASS_NAME_PREFIX = "Probe_";
    static final String INVOCATION_OBJECT_TYPE_SIGNATURE = "Ljava/lang/Object;";
    private Map probeDetailsMap;
    private int nextSerialNumber;

    public Compiler() {
    }

    public Compiler(Probekit probekit) {
        this.probekits.add(new ProbekitPair(probekit, (IResource)ProbekitPlugin.getWorkspace().getRoot()));
    }

    public Compiler(String string) throws ProbekitException {
        this.addFile(string);
    }

    public void addProbekit(Probekit probekit) throws ProbekitException {
        this.probekits.add(new ProbekitPair(probekit, (IResource)ProbekitPlugin.getWorkspace().getRoot()));
    }

    public void addFile(String string) throws ProbekitException {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createFileURI((String)string);
        Resource resource = resourceSetImpl.getResource(uRI, true);
        if (resource == null) {
            throw new ProbekitException(ProbekitPlugin.getString("Compiler.CantReadSourceFile") + string);
        }
        this.addResource(resource);
    }

    public void addResource(Resource resource) throws ProbekitException {
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof DocumentRoot)) {
                throw new ProbekitException("Probe compiler internal error: resource doesn't contain a DocumentRoot");
            }
            DocumentRoot documentRoot = (DocumentRoot)e;
            Probekit probekit = documentRoot.getProbekit();
            if (probekit == null) continue;
            this.probekits.add(new ProbekitPair(probekit, (IResource)ProbekitPlugin.getWorkspace().getRoot()));
        }
        this.setDirtyState();
    }

    public String addResource(Resource resource, IResource iResource) throws ProbekitException {
        Iterator iterator = resource.getContents().iterator();
        String string = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof DocumentRoot)) {
                throw new ProbekitException(ProbekitPlugin.getString("Compiler.NoProbekitResource"));
            }
            DocumentRoot documentRoot = (DocumentRoot)e;
            Probekit probekit = documentRoot.getProbekit();
            if (probekit == null) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbekitSource"), iResource);
                continue;
            }
            this.probekits.add(new ProbekitPair(probekit, iResource));
            string = probekit.getId();
        }
        this.setDirtyState();
        return string;
    }

    public String addIFile(IFile iFile) throws ProbekitException {
        Resource resource;
        this.removeProbekitMarkers((IResource)iFile);
        try {
            if (!iFile.exists()) {
                this.reportError(ProbekitPlugin.getString("Compiler.MissingFile"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
            IPath iPath = iFile.getLocation();
            if (iPath == null) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbekitResource"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
            File file = iPath.toFile();
            if (file.length() == 0L) {
                this.reportError(ProbekitPlugin.getString("Compiler.EmptyFile"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            URI uRI = URI.createFileURI((String)iPath.toOSString());
            resource = resourceSetImpl.getResource(uRI, true);
            if (resource == null) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbekitResource"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
        }
        catch (ProbekitCompileProblemException probekitCompileProblemException) {
            throw probekitCompileProblemException;
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitPlugin.getString("Compiler.NoProbekitObject"), (Throwable)exception);
            ProbekitPlugin.getDefault().getLog().log((IStatus)status);
            this.reportError(ProbekitPlugin.getString("Compiler.NoProbekitObjectWithErrorLog"), (IResource)iFile);
            throw new ProbekitCompileProblemException(EMPTY_STRING);
        }
        return this.addResource(resource, (IResource)iFile);
    }

    public void setClassPrefix(String string) throws ProbekitException {
        if (!this.isValidJavaIdentifier(string, false)) {
            throw new ProbekitException(ProbekitPlugin.getString("Compiler.BadSetPrefixArg") + string);
        }
        this.classPrefix = string;
        this.setDirtyState();
    }

    public void setPackageName(String string) throws ProbekitException {
        if (!this.isValidJavaIdentifier(string, true)) {
            throw new ProbekitException("Probekit API error: bad argument to setPackageName: " + string);
        }
        this.packageName = string;
    }

    public String getClassSuffix() {
        return "_probe";
    }

    public String makeValidJavaIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n > 0) {
            char c = string.charAt(0);
            if (!Character.isJavaIdentifierStart(c)) {
                stringBuffer.append('_');
                stringBuffer.append(Integer.toString(c, 16).toUpperCase());
            } else {
                stringBuffer.append(c);
            }
            for (int i = 1; i < n; ++i) {
                c = string.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    stringBuffer.append('_');
                    stringBuffer.append(Integer.toString(c, 16).toUpperCase());
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    private void removeProbekitMarkers(IResource iResource) {
        try {
            iResource.deleteMarkers("org.eclipse.hyades.probekit.probekitProblem", true, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void reportError(String string, IResource iResource) {
        this.compilerState = 2;
        try {
            IMarker iMarker = iResource.createMarker("org.eclipse.hyades.probekit.probekitProblem");
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitPlugin.getString("Compiler.MarkerCreateError"), null);
            ProbekitPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public void verify() throws ProbekitException {
        if (this.probekits.size() == 0) {
            throw new ProbekitException(ProbekitPlugin.getString("Compiler.VerifyBeforeAdd"));
        }
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            ProbekitPair probekitPair = (ProbekitPair)iterator.next();
            Probekit probekit = probekitPair.probekit;
            IResource iResource = probekitPair.iresource;
            if (probekit.getLabel() != null) {
                boolean bl = false;
                int n = 0;
                iterator2 = probekit.getLabel().iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!(e instanceof Label)) {
                        this.reportError("Probekit internal error: a member of the Labels list is not a label", iResource);
                        continue;
                    }
                    Label label = (Label)e;
                    String string = label.getLang();
                    String string2 = label.getName();
                    String string3 = label.getDescription();
                    if (string == null || string.equals(EMPTY_STRING)) {
                        if (bl) {
                            this.reportError(ProbekitPlugin.getString("Compiler.MultipleDefaultLabels"), iResource);
                        }
                        bl = true;
                    } else {
                        ++n;
                    }
                    if (string2 != null && !string2.equals(EMPTY_STRING)) continue;
                    this.reportError(ProbekitPlugin.getString("Compiler.EmptyNameInLabel"), iResource);
                }
                if (!bl && n > 1) {
                    this.reportError(ProbekitPlugin.getString("Compiler.MultipleLabelsNoDefault"), iResource);
                }
            }
            if (probekit.getProbe() == null) {
                this.reportError("Probekit has a null probe list (internal error)", iResource);
                continue;
            }
            if (probekit.getProbe().size() == 0) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbesInProbekit"), iResource);
            }
            Iterator iterator3 = probekit.getProbe().iterator();
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                if (!(e instanceof Probe)) {
                    this.reportError(ProbekitPlugin.getString("Compiler.NonProbeObject"), iResource);
                    continue;
                }
                iterator2 = (Probe)e;
                this.verifyOneProbe((Probe)iterator2, iResource);
            }
        }
        if (this.compilerState == 2) {
            throw new ProbekitCompileProblemException(EMPTY_STRING);
        }
    }

    private void verifyOneProbe(Probe probe, IResource iResource) {
        Object object;
        DataItem dataItem;
        Iterator iterator;
        int n;
        Object object2;
        Object object3;
        if (probe.getImport() != null) {
            object3 = probe.getImport().iterator();
            while (object3.hasNext()) {
                object2 = (Import)object3.next();
                String string = object2.getText();
                if (string != null && !string.equals(EMPTY_STRING)) continue;
                this.reportError(ProbekitPlugin.getString("Compiler.EmptyPackageName"), iResource);
            }
        }
        if ((object3 = probe.getStaticField()) != null) {
            object2 = object3.getType();
            if (object2 == null || ((String)object2).equals(EMPTY_STRING)) {
                this.reportError(ProbekitPlugin.getString("Compiler.EmptyStaticFieldType"), iResource);
            } else {
                if (!this.isValidJavaIdentifier((String)object2, true)) {
                    this.reportError(ProbekitPlugin.getString("Compiler.BadStaticFieldType") + (String)object2, iResource);
                }
                for (int i = 0; i < primitiveTypes.length; ++i) {
                    if (!((String)object2).equals(primitiveTypes[i])) continue;
                    this.reportError(ProbekitPlugin.getString("Compiler.StaticFieldTypeIsPrimitive") + (String)object2, iResource);
                }
            }
        }
        if (probe.getFragment().size() != 0 || object3 == null) {
            // empty if block
        }
        object2 = new boolean[fragmentDescriptors.length];
        Iterator iterator2 = probe.getFragment().iterator();
        while (iterator2.hasNext()) {
            Fragment fragment = (Fragment)iterator2.next();
            FragmentType fragmentType = fragment.getType();
            if (fragmentType == null) {
                this.reportError("Probekit internal error: a fragment type is null", iResource);
                continue;
            }
            String string = fragmentType.getName();
            if (string == null || string.equals(EMPTY_STRING)) {
                this.reportError("Probekit internal error: a fragment type string is null or empty", iResource);
                continue;
            }
            try {
                n = Compiler.FragTypeNameToNumber(string);
                if (object2[n] != false) {
                    this.reportError(ProbekitPlugin.getString("Compiler.MultipleFragmentsSameType") + string, iResource);
                }
                object2[n] = true;
            }
            catch (ProbekitException probekitException) {
                this.reportError(ProbekitPlugin.getString("Compiler.InvalidFragmentType") + string, iResource);
                continue;
            }
            boolean[] blArray = new boolean[dataItemDescs.length];
            if (fragment.getData() != null) {
                iterator = fragment.getData().iterator();
                while (iterator.hasNext()) {
                    dataItem = (DataItem)iterator.next();
                    object = dataItem.getType();
                    if (object == null) {
                        this.reportError("Probekit internal error: a data item type enum is null", iResource);
                        continue;
                    }
                    String string2 = object.getName();
                    if (string2 == null) {
                        this.reportError("Probekit internal error: a data item has null type string", iResource);
                        continue;
                    }
                    boolean bl = false;
                    for (int i = 0; i < dataItemDescs.length; ++i) {
                        if (!string2.equals(Compiler.dataItemDescs[i].typeName)) continue;
                        if (blArray[i]) {
                            this.reportError(ProbekitPlugin.getString("Compiler.DuplicateDataItem1") + string + ProbekitPlugin.getString("Compiler.DuplicateDataItem2") + string2, iResource);
                        }
                        blArray[i] = true;
                        if (!Compiler.fragmentDescriptors[n].allowableDataItems[i]) {
                            this.reportError(ProbekitPlugin.getString("Compiler.DataItemNotAllowed1") + " \"" + string2 + "\" " + ProbekitPlugin.getString("Compiler.DataItemNotAllowed2") + string, iResource);
                        }
                        if (string2.equals("staticField") && object3 == null) {
                            this.reportError(ProbekitPlugin.getString("Compiler.NoStaticFieldAvailable") + string, iResource);
                        }
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.reportError(ProbekitPlugin.getString("Compiler.BadDataItemType") + string2, iResource);
                    }
                    if (dataItem.getName() == null || dataItem.getName().equals(EMPTY_STRING)) {
                        this.reportError(ProbekitPlugin.getString("Compiler.MissingDataItemName"), iResource);
                        continue;
                    }
                    if (this.isValidJavaIdentifier(dataItem.getName(), false)) continue;
                    this.reportError(ProbekitPlugin.getString("Compiler.BadDataItemName") + dataItem.getName(), iResource);
                }
            }
            if (fragment.getCode() != null && !fragment.getCode().equals(EMPTY_STRING)) continue;
            this.reportError(ProbekitPlugin.getString("Compiler.FragmentIsMissingCode"), iResource);
        }
        int n2 = object2[3] | object2[4];
        int n3 = object2[0] | object2[1] | object2[2] | object2[5] | object2[6];
        if (n2 != 0 && n3 != 0) {
            this.reportError(ProbekitPlugin.getString("Compiler.BadFragmentTypeCombo"), iResource);
        }
        if (n2 != 0 && object3 != null) {
            this.reportError(ProbekitPlugin.getString("Compiler.CallsiteCantUseStaticField"), iResource);
        }
        boolean bl = false;
        boolean bl2 = false;
        n = 0;
        boolean bl3 = false;
        iterator = probe.getTarget().iterator();
        while (iterator.hasNext()) {
            if (n == 1) {
                this.reportError(ProbekitPlugin.getString("Compiler.TargetsAfterStars"), iResource);
                n = 2;
            }
            if ((object = (dataItem = (Target)iterator.next()).getType()) == null || ((String)object).equals(EMPTY_STRING)) {
                this.reportError(ProbekitPlugin.getString("Compiler.MissingTargetType"), iResource);
                continue;
            }
            if (((String)object).equals("exclude")) {
                bl = true;
                bl3 = false;
            } else if (((String)object).equals("include")) {
                bl3 = true;
            } else {
                bl2 = true;
                this.reportError(ProbekitPlugin.getString("Compiler.BadTargetType") + dataItem.getType(), iResource);
            }
            if (this.hasWhitespace(dataItem.getClassName()) || this.hasWhitespace(dataItem.getMethod()) || this.hasWhitespace(dataItem.getPackage()) || this.hasWhitespace(dataItem.getSignature())) {
                this.reportError(ProbekitPlugin.getString("Compiler.BadTargetPattern"), iResource);
            }
            if (!Compiler.emptyNullOrStar(dataItem.getClassName()) || !Compiler.emptyNullOrStar(dataItem.getMethod()) || !Compiler.emptyNullOrStar(dataItem.getPackage()) || !Compiler.emptyNullOrStar(dataItem.getSignature())) continue;
            n = 1;
        }
        if (probe.getTarget().size() > 0 && !bl2) {
            if (!bl) {
                this.reportError(ProbekitPlugin.getString("Compiler.BadTargetAllInclude"), iResource);
            } else if (bl3) {
                this.reportError(ProbekitPlugin.getString("Compiler.LastTargetIsInclude"), iResource);
            }
        }
        if (probe.getControlKey() != null) {
            this.reportError(ProbekitPlugin.getString("Compiler.ControlKeyNotImpl"), iResource);
        }
        if (probe.getInvocationObject() != null) {
            this.reportError(ProbekitPlugin.getString("Compiler.InvocationObjectNotImpl"), iResource);
        }
    }

    boolean isValidJavaIdentifier(String string, boolean bl) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl && c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    boolean hasWhitespace(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static String dotsToSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string.length(); ++i) {
            if (stringBuffer.charAt(i) != '.') continue;
            stringBuffer.setCharAt(i, '/');
        }
        return stringBuffer.toString();
    }

    static boolean emptyNullOrStar(String string) {
        return string == null || string.length() == 0 || string.equals("*");
    }

    private void compile() throws ProbekitException {
        if (this.compilerState == 0) {
            Iterator iterator = this.probekits.iterator();
            while (iterator.hasNext()) {
                ProbekitPair probekitPair = (ProbekitPair)iterator.next();
                IResource iResource = probekitPair.iresource;
                if (iResource != iResource.getWorkspace().getRoot()) continue;
                this.removeProbekitMarkers(iResource);
                break;
            }
            this.verify();
        }
        if (this.compilerState == 2) {
            throw new ProbekitCompileProblemException(EMPTY_STRING);
        }
        this.generateSource();
        this.generateEngineScript();
    }

    public String getGeneratedSource() throws ProbekitException {
        this.compile();
        return this.generatedSource.toString();
    }

    public String getEngineScript() throws ProbekitException {
        this.compile();
        return this.engScript.toString();
    }

    void generateEngineScript() throws ProbekitException {
        this.engScript = new StringBuffer();
        Iterator iterator = this.probeDetailsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Target target;
            Map.Entry entry = iterator.next();
            Probe probe = (Probe)entry.getKey();
            ProbeDetails probeDetails = (ProbeDetails)entry.getValue();
            this.engScript.append("REM " + probeDetails.commentName + lineSeparator);
            this.engScript.append("PROBE" + lineSeparator);
            Iterator iterator2 = probe.getTarget().iterator();
            while (iterator2.hasNext()) {
                String string2;
                String string3;
                String string4;
                target = (Target)iterator2.next();
                string = target.getPackage();
                if (Compiler.emptyNullOrStar(string)) {
                    string = "*";
                }
                if (!string.equals(".")) {
                    string = Compiler.dotsToSlashes(string);
                }
                if (Compiler.emptyNullOrStar(string4 = target.getClassName())) {
                    string4 = "*";
                }
                if (Compiler.emptyNullOrStar(string3 = target.getMethod())) {
                    string3 = "*";
                }
                if (Compiler.emptyNullOrStar(string2 = target.getSignature())) {
                    string2 = "*";
                }
                this.engScript.append("RULE " + string + SPACE_STRING + string4 + SPACE_STRING + string3 + SPACE_STRING + string2 + SPACE_STRING + target.getType() + lineSeparator);
            }
            iterator2 = probe.getFragment().iterator();
            while (iterator2.hasNext()) {
                target = (Fragment)iterator2.next();
                string = target.getType().getName();
                int n = Compiler.FragTypeNameToNumber(string);
                this.engScript.append("REF ");
                this.engScript.append(Compiler.fragmentDescriptors[n].engineScriptOpcode);
                this.engScript.append(SPACE_STRING);
                this.engScript.append(this.getOuterClassName() + "$" + probeDetails.uniqueClassName + SPACE_STRING);
                this.engScript.append(probeDetails.fragmentDetails[n].functionName + SPACE_STRING);
                this.engScript.append(probeDetails.fragmentDetails[n].signature + SPACE_STRING);
                this.engScript.append(probeDetails.fragmentDetails[n].argumentList + lineSeparator);
            }
            if (probeDetails.staticFieldType == null) continue;
            this.engScript.append("STATICFIELD " + probeDetails.staticFieldTypeInternal + lineSeparator);
        }
    }

    private void generateSource() throws ProbekitException {
        Probe probe;
        Iterator iterator;
        Probekit probekit;
        ProbekitPair probekitPair;
        this.generatedSource = new StringBuffer();
        this.engScript = new StringBuffer();
        this.probeDetailsMap = new HashMap();
        this.nextSerialNumber = 0;
        this.compilerState = 0;
        this.emitln("// generated source from ProbeKit compiler");
        this.emitln("// List of probes in this probe set:");
        Iterator iterator2 = this.probekits.iterator();
        while (iterator2.hasNext()) {
            probekitPair = (ProbekitPair)iterator2.next();
            probekit = probekitPair.probekit;
            iterator = probekit.getProbe().iterator();
            while (iterator.hasNext()) {
                probe = (Probe)iterator.next();
                ProbeDetails probeDetails = new ProbeDetails(probe);
                this.probeDetailsMap.put(probe, probeDetails);
                this.emitln("//   " + probeDetails.commentName);
            }
        }
        if (this.packageName != null) {
            this.emitln("package " + this.packageName + ";");
        }
        this.emitln("// \"imports\" specifications for probes (if any):");
        this.emitImports();
        this.emitln("class " + this.getOuterClassName() + " {");
        iterator2 = this.probekits.iterator();
        while (iterator2.hasNext()) {
            probekitPair = (ProbekitPair)iterator2.next();
            probekit = probekitPair.probekit;
            iterator = probekit.getProbe().iterator();
            while (iterator.hasNext()) {
                probe = (Probe)iterator.next();
                this.emitOneProbeInnerClass(probe);
            }
        }
        this.emitln("}");
        this.compilerState = 1;
    }

    private void setDirtyState() {
        this.generatedSource = null;
        this.engScript = null;
        this.compilerState = 0;
    }

    private void emit(String string) {
        this.generatedSource.append(string);
    }

    private void emitln(String string) {
        this.generatedSource.append(string);
        this.generatedSource.append(lineSeparator);
    }

    private String getOuterClassName() {
        return this.classPrefix + this.getClassSuffix();
    }

    private static int FragTypeNameToNumber(String string) throws ProbekitException {
        for (int i = 0; i < fragmentDescriptors.length; ++i) {
            if (!string.equals(Compiler.fragmentDescriptors[i].typeName)) continue;
            return i;
        }
        throw new ProbekitException("IWAT5008 Internal Probekit error, bad fragment type name: " + string);
    }

    private void emitImports() throws ProbekitException {
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            ProbekitPair probekitPair = (ProbekitPair)iterator.next();
            Probekit probekit = probekitPair.probekit;
            Iterator iterator2 = probekit.getProbe().iterator();
            while (iterator2.hasNext()) {
                Probe probe = (Probe)iterator2.next();
                if (probe.getImport() == null) continue;
                Object v = this.probeDetailsMap.get(probe);
                if (v == null) {
                    throw new ProbekitException("IWAT5009E Probekit internal error: failed to find details for probe");
                }
                ProbeDetails probeDetails = (ProbeDetails)v;
                Iterator iterator3 = probe.getImport().iterator();
                while (iterator3.hasNext()) {
                    Import import_ = (Import)iterator3.next();
                    this.emitln("import " + import_.getText() + "; // from " + probeDetails.commentName);
                }
            }
        }
    }

    private String getNextProbeClassName() {
        String string = PROBE_INNER_CLASS_NAME_PREFIX + this.nextSerialNumber;
        ++this.nextSerialNumber;
        return string;
    }

    private void emitOneProbeInnerClass(Probe probe) throws ProbekitException {
        Object v = this.probeDetailsMap.get(probe);
        if (v == null) {
            throw new ProbekitException("IWAT5010E Internal error: failed to find details for probe");
        }
        ProbeDetails probeDetails = (ProbeDetails)v;
        this.emitln("  // Class for probe " + probeDetails.commentName);
        probeDetails.uniqueClassName = this.getNextProbeClassName();
        this.emitln("  public static class " + probeDetails.uniqueClassName + " {");
        String string = probe.getFragmentAtClassScope();
        if (string != null && !string.equals(EMPTY_STRING)) {
            this.emitln("    // Fragment at class scope");
            this.emitln(string);
        }
        Iterator iterator = probe.getFragment().iterator();
        while (iterator.hasNext()) {
            Fragment fragment = (Fragment)iterator.next();
            String string2 = fragment.getType().getName();
            int n = Compiler.FragTypeNameToNumber(string2);
            String string3 = "_" + string2;
            probeDetails.fragmentDetails[n] = new ProbeDetails.FragmentDetails();
            probeDetails.fragmentDetails[n].functionName = string3;
            String string4 = "void";
            String string5 = "V";
            this.emitln("    public static " + string4 + SPACE_STRING + string3 + " (");
            boolean bl = true;
            probeDetails.fragmentDetails[n].signature = "(";
            probeDetails.fragmentDetails[n].argumentList = new String();
            for (int i = 0; i < dataItemDescs.length; ++i) {
                Iterator iterator2 = fragment.getData().iterator();
                while (iterator2.hasNext()) {
                    String string6;
                    String string7;
                    DataItem dataItem = (DataItem)iterator2.next();
                    if (!dataItem.getType().getName().equals(Compiler.dataItemDescs[i].typeName)) continue;
                    if (Compiler.dataItemDescs[i].typeType.equals(EMPTY_STRING)) {
                        string7 = probeDetails.staticFieldType;
                        string6 = "L" + probeDetails.staticFieldTypeInternal + ";";
                    } else {
                        string7 = Compiler.dataItemDescs[i].typeType;
                        string6 = Compiler.dataItemDescs[i].typeSignature;
                    }
                    String string8 = dataItem.getName();
                    if (!bl) {
                        this.emitln(",");
                    }
                    this.emit("      " + string7 + " /*" + Compiler.dataItemDescs[i].typeName + "*/ " + string8);
                    probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + string6;
                    if (!bl) {
                        probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + ",";
                    }
                    probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + Compiler.dataItemDescs[i].typeName;
                    bl = false;
                }
            }
            this.emitln("      ) {");
            probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + ")" + string5;
            this.emitln("      // Internal signature for this method: " + probeDetails.fragmentDetails[n].signature);
            this.emitln("//------------------ begin user-written fragment code ----------------");
            this.emitln(fragment.getCode());
            this.emitln("//------------------- end user-written fragment code -----------------");
            this.emitln("    }");
        }
        this.emitln("  }");
    }

    static /* synthetic */ FragmentDescriptor[] access$000() {
        return fragmentDescriptors;
    }

    public static class ProbeDetails {
        public String commentName = "";
        public String uniqueClassName = "";
        public String staticFieldType;
        public String staticFieldTypeInternal;
        public FragmentDetails[] fragmentDetails = new FragmentDetails[Compiler.access$000().length];

        public ProbeDetails(Probe probe) {
            this.commentName = probe.getName() == null || probe.getName().size() == 0 ? "unnamed_probe" : ((Name)probe.getName().get(0)).getText();
            StaticField staticField = probe.getStaticField();
            if (staticField != null && !staticField.equals(Compiler.EMPTY_STRING)) {
                this.staticFieldType = staticField.getType();
                this.staticFieldTypeInternal = Compiler.dotsToSlashes(staticField.getType());
            }
        }

        static class FragmentDetails {
            public String functionName;
            public String signature;
            public String argumentList;

            FragmentDetails() {
            }
        }
    }

    private static class DataItemDesc {
        public String typeName;
        public String typeType;
        public String typeSignature;

        public DataItemDesc(String string, String string2, String string3) {
            this.typeName = string;
            this.typeType = string2;
            this.typeSignature = string3;
        }
    }

    private static class FragmentDescriptor {
        public String typeName;
        public String engineScriptOpcode;
        public boolean[] allowableDataItems;

        public FragmentDescriptor(String string, String string2, boolean[] blArray) {
            this.typeName = string;
            this.engineScriptOpcode = string2;
            this.allowableDataItems = blArray;
        }
    }

    static class ProbekitPair {
        public Probekit probekit;
        public IResource iresource;

        ProbekitPair(Probekit probekit, IResource iResource) {
            this.probekit = probekit;
            this.iresource = iResource;
        }
    }
}

