/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SDbPlugin
extends AbstractUIPlugin {
    private static SDbPlugin inst;
    private static ResourceBundle fResourceBundle;
    private SDBFactoryImpl factory;
    private ResourceSet resourceSet;

    public SDbPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        if (inst == null) {
            inst = this;
        }
        try {
            fResourceBundle = this.getDescriptor().getResourceBundle();
        }
        catch (MissingResourceException x) {
            x.printStackTrace();
        }
    }

    public static SDbPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return SDbPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return SDbPluginImages.getImageDescriptor(name);
    }

    public static ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SDbPlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public void shutdown() throws CoreException {
        SDbPluginImages.shutdown();
        super.shutdown();
    }

    public void startup() throws CoreException {
        SDBPackageImpl.init();
        this.factory = new SDBFactoryImpl();
        this.resourceSet = SDBResourceSetImpl.getInstance();
        super.startup();
    }

    public SDBFactoryImpl getSDBFactory() {
        if (this.factory == null) {
            this.factory = new SDBFactoryImpl();
        }
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        String url = SDbPlugin.getResourceString("STR_StdURL_NAME") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + SDbPlugin.getResourceString("STR_AdvURL_NAME") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/adv/symptomdb.xml" + "\n" + SDbPlugin.getResourceString("STR_StdURL_NAME_V5") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + SDbPlugin.getResourceString("STR_AdvURL_NAME_V5") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/adv/symptomdb.xml";
        store.setDefault("symptom_db_url", url);
    }
}

