/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class IndexQuery
extends QueryStatement {
    protected Integer sourceId;
    protected Integer targetId;
    protected Column source;
    protected Column target;
    protected Column order;

    public IndexQuery(DatabaseType type, DBMap map, Integer sourceId, EReference reference, Integer targetId) {
        super(type, map, (EModelElement)reference);
        this.sourceId = sourceId;
        this.targetId = targetId;
        DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)reference);
        this.source = data.getSourceColumn();
        this.target = data.getTargetColumn();
        this.order = data.getOrderColumn();
    }

    public String getStatement() {
        if (this.statement.length() != 0) {
            return this.statement.toString();
        }
        this.statement.append("SELECT ");
        this.statement.append(this.addQuotes(this.order.getName()));
        this.statement.append(" FROM ");
        this.statement.append(this.addQuotes(this.table.getName()));
        this.createWhereClause();
        return this.statement.toString();
    }

    protected void createWhereClause() {
        this.statement.append(" WHERE ");
        this.statement.append(this.addQuotes(this.source.getName()));
        this.statement.append(" = ");
        this.statement.append(this.sourceId);
        this.statement.append(" AND ");
        this.statement.append(this.addQuotes(this.target.getName()));
        this.statement.append(" = ");
        this.statement.append(this.targetId);
    }

    public EClass getEClass() {
        return null;
    }

    public String getKeyName() {
        return null;
    }
}

