/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.event;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.test.common.event.EventProperty;
import org.eclipse.hyades.test.common.event.IEventConstants;
import org.eclipse.hyades.test.common.util.XMLUtil;

public class ExecutionEvent
implements IEventConstants {
    private String id;
    private String parentId;
    private String ownerId;
    private long timestamp;
    private String text;
    private String name;
    private String eventType;
    private String sortBy;
    private int conflict = 0;
    private ArrayList properties = new ArrayList();

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String string) {
        this.parentId = string;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String string) {
        this.ownerId = string;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String string) {
        this.sortBy = string;
    }

    public int getConflict() {
        return this.conflict;
    }

    public void setConflict(int n) {
        this.conflict = n;
    }

    public ArrayList getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(this.getXMLRoot());
        this.addXMLAttributes(stringBuffer);
        stringBuffer.append(">");
        this.addXMLProperties(stringBuffer);
        stringBuffer.append("</").append(this.getXMLRoot());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected String getXMLRoot() {
        return "executionEvent";
    }

    protected String getXMLPropertyRoot() {
        return "property";
    }

    protected void addXMLAttributes(StringBuffer stringBuffer) {
        long l;
        stringBuffer.append(XMLUtil.createXMLAttribute("id", this.getId(), false).toString());
        stringBuffer.append(XMLUtil.createXMLAttribute("ownerId", this.getOwnerId(), false).toString());
        stringBuffer.append(XMLUtil.createXMLAttribute("text", this.getText(), false).toString());
        if (this.parentId != null && !this.parentId.equals("")) {
            stringBuffer.append(XMLUtil.createXMLAttribute("parentId", this.getParentId(), false).toString());
        }
        if ((l = this.getTimestamp()) == 0L) {
            l = System.currentTimeMillis();
        }
        stringBuffer.append(XMLUtil.createXMLAttribute("timestamp", Long.toString(l), false).toString());
        stringBuffer.append(XMLUtil.createXMLAttribute("name", this.getName(), false).toString());
        stringBuffer.append(XMLUtil.createXMLAttribute("eventType", this.getEventType(), false).toString());
        stringBuffer.append(XMLUtil.createXMLAttribute("sortBy", this.getSortBy(), false).toString());
        if (this.getConflict() != 0) {
            stringBuffer.append(XMLUtil.createXMLAttribute("conflict", Integer.toString(this.getConflict()), false).toString());
        }
    }

    protected void addXMLProperties(StringBuffer stringBuffer) {
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EventProperty eventProperty = (EventProperty)iterator.next();
            stringBuffer.append("<").append(this.getXMLPropertyRoot());
            stringBuffer.append(XMLUtil.createXMLAttribute("pname", eventProperty.getName(), false).toString());
            stringBuffer.append(XMLUtil.createXMLAttribute("ptype", eventProperty.getType(), false).toString());
            stringBuffer.append(XMLUtil.createXMLAttribute("pvalue", eventProperty.getValue(), false).toString());
            stringBuffer.append("/>");
        }
    }
}

