/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;

/**
 * @author psun
 *
 */
public class DatapoolUtil 
{
	private static final DatapoolUtil instance = new DatapoolUtil();

	public static DatapoolUtil getInstance()
	{
		return instance;
	}
	
	protected DatapoolUtil()
	{
	}
	
	public boolean isVariableNameValid(String name)
	{
		if(name.length() == 0)
			return false;		
		String invalidCharacters = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_NAME_CHARACTERS"); //$NON-NLS-1$
		// TODO: This is a temporary hack because I can't change the properties file.
		invalidCharacters = invalidCharacters.replaceAll(" ", ""); //$NON-NLS-1$
		return !hasInvalidCharacters(name, invalidCharacters);
	}
	
	public boolean isVariableTypeValid(String type)
	{
		if(type.length() == 0)
			return true;
		String invalidCharacters = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_TYPE_CHARACTERS"); //$NON-NLS-1$
		String invalidFirstCharacter = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_TYPE_FIRST_CHARACTER"); //$NON-NLS-1$
		if(hasInvalidCharacters(type.substring(0,1), invalidFirstCharacter))
		{
			return false;
		}
		return !hasInvalidCharacters(type, invalidCharacters);
	}

	public boolean isEquivalenceClassNameValid(String name)
	{
		if(name.length() == 0)
			return false;		
		String invalidCharacters = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_NAME_CHARACTERS"); //$NON-NLS-1$
		// TODO: This is a temporary hack because I can't change the properties file.
		invalidCharacters = invalidCharacters.replaceAll(" ", ""); //$NON-NLS-1$
		return !hasInvalidCharacters(name, invalidCharacters);
	}

	public boolean hasInvalidCharacters(String value, String invalidCharacters)
	{
		if(invalidCharacters == null)
			return false;
		for(int i = 0; i < invalidCharacters.length(); i++)
		{
			String character = invalidCharacters.substring(i, i+1);
			if(value.lastIndexOf(character) != -1)
				return true;	
		}
		return false;		
	}
	
	public boolean isEquivalenceClassNameUnique(IDatapool datapool, String name, IDatapoolEquivalenceClass excludeEquivalenceClass)
	{
		if(datapool == null)
			return true;
		for(int i = 0; i < datapool.getEquivalenceClassCount(); i++)
		{
			IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
			if(!equivalenceClass.equals(excludeEquivalenceClass) && name.equals(equivalenceClass.getName()))
				return false;
		}
		return true;
	
	}
	
	public boolean isVariableNameUnique(IDatapool datapool, String name, IDatapoolVariable excludeVariable)
	{
		if(datapool == null)
			return true;
		for(int i = 0; i < datapool.getVariableCount(); i++)
		{
			IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
			if(!variable.equals(excludeVariable) && name.equals(variable.getName()))
				return false;
		}
		return true;			
	}

	public IDatapoolVariable[] getVariables(IDatapool datapool, String exclusionName)
	{
		if(datapool == null)
			return null;
		int variableCount = datapool.getVariableCount();
		ArrayList tempList = new ArrayList();
		for(int i = 0; i < variableCount; i++)
		{
			IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
			String variableName = variable.getName();
			if(variableName.equals(exclusionName))
				continue;
			else
				tempList.add(variable);
		}

		int listSize = tempList.size();
		IDatapoolVariable[] returnList = new IDatapoolVariable[listSize];
		tempList.toArray(returnList);
		return returnList;
	}
		
	public IDatapoolEquivalenceClass[] getEquivalenceClasses(IDatapool datapool, String exclusionID)
	{
		if(datapool == null)
			return null;
		int equivalenceClassCount = datapool.getEquivalenceClassCount();
		ArrayList tempList = new ArrayList();
		for(int i = 0; i < equivalenceClassCount; i++)
		{
			IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
			String equivalenceClassID = equivalenceClass.getId();
			if(equivalenceClassID.equals(exclusionID))
				continue;
			else
				tempList.add(equivalenceClass);
		}
		int listSize = tempList.size();
		IDatapoolEquivalenceClass[] returnList = new IDatapoolEquivalenceClass[listSize];
		tempList.toArray(returnList);
		return returnList;
	}
	
}
