/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.test.java.internal.codegen.JUnitGenerator;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.ITestLaunchConfigurationValidator;

/**
 * @see ITestLaunchConfigurationValidator
 */
public class TestLaunchConfigurationValidator implements ITestLaunchConfigurationValidator {

	/**
	 * @see ITestLaunchConfigurationValidator#validate
	 */
	public Diagnostic validate(ILaunchConfiguration launchConfiguration)  {
		TPFTest test;
		try {
			test = TestLaunchConfigurationFacade.getTest(launchConfiguration);
		} catch (CoreException e) {
			test = null;
		}
		if (test != null) {
			TPFTestSuite testSuite = null;
			if (test instanceof TPFTestCase) {
				testSuite = ((TPFTestCase)test).getTestSuite();
			} else if (test instanceof TPFTestSuite) {
				testSuite = (TPFTestSuite)test;
			}
			if (testSuite != null) {
				Generator generator = new JUnitGenerator();
				if (!generator.getFileHandle(testSuite).exists()) {
					// The code has not been generated yet. Issue an error
					return new Diagnostic() {
						public String getMessage() {
							// TODO Externalize this String in post-3.0 release. (this string was added after PII freeze).
							return "The source code for the selected Test Suite is not generated. Please generate code for this Test Suite ir order to execute it.";
						}
						public int getSeverity() {
							return ERROR;
						}
					};
				}
			}
			return null;
		}
		return null;
	}
}
