/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Instance Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.InstanceQueryImpl#getConditions <em>Conditions</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InstanceQueryImpl extends QueryImpl implements InstanceQuery {
	/**
	 * The cached value of the '{@link #getConditions() <em>Conditions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConditions()
	 * @generated
	 * @ordered
	 */
	protected EList conditions = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceQueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getInstanceQuery();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getConditions() {
		if (conditions == null) {
			conditions = new EObjectContainmentWithInverseEList(SimpleBinaryExpression.class, this, ExtensionsPackage.INSTANCE_QUERY__CONDITIONS, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY);
		}
		return conditions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.INSTANCE_QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicAdd(otherEnd, msgs);
				case ExtensionsPackage.INSTANCE_QUERY__CONDITIONS:
					return ((InternalEList)getConditions()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.INSTANCE_QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.INSTANCE_QUERY__CONDITIONS:
					return ((InternalEList)getConditions()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.INSTANCE_QUERY__NAME:
				return getName();
			case ExtensionsPackage.INSTANCE_QUERY__SOURCES:
				return getSources();
			case ExtensionsPackage.INSTANCE_QUERY__DISTINCT:
				return isDistinct() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.INSTANCE_QUERY__COUNT:
				return isCount() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.INSTANCE_QUERY__OUTPUT_ELEMENTS:
				return getOutputElements();
			case ExtensionsPackage.INSTANCE_QUERY__CONDITIONS:
				return getConditions();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.INSTANCE_QUERY__NAME:
				setName((String)newValue);
				return;
			case ExtensionsPackage.INSTANCE_QUERY__SOURCES:
				getSources().clear();
				getSources().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.INSTANCE_QUERY__DISTINCT:
				setDistinct(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.INSTANCE_QUERY__COUNT:
				setCount(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.INSTANCE_QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				getOutputElements().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.INSTANCE_QUERY__CONDITIONS:
				getConditions().clear();
				getConditions().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.INSTANCE_QUERY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ExtensionsPackage.INSTANCE_QUERY__SOURCES:
				getSources().clear();
				return;
			case ExtensionsPackage.INSTANCE_QUERY__DISTINCT:
				setDistinct(DISTINCT_EDEFAULT);
				return;
			case ExtensionsPackage.INSTANCE_QUERY__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
			case ExtensionsPackage.INSTANCE_QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				return;
			case ExtensionsPackage.INSTANCE_QUERY__CONDITIONS:
				getConditions().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.INSTANCE_QUERY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ExtensionsPackage.INSTANCE_QUERY__SOURCES:
				return sources != null && !sources.isEmpty();
			case ExtensionsPackage.INSTANCE_QUERY__DISTINCT:
				return distinct != DISTINCT_EDEFAULT;
			case ExtensionsPackage.INSTANCE_QUERY__COUNT:
				return count != COUNT_EDEFAULT;
			case ExtensionsPackage.INSTANCE_QUERY__OUTPUT_ELEMENTS:
				return outputElements != null && !outputElements.isEmpty();
			case ExtensionsPackage.INSTANCE_QUERY__CONDITIONS:
				return conditions != null && !conditions.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //InstanceQueryImpl
