/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.hierarchy.util;

/**
 * @author slavescu
 */

public final class IndexHashTable {
	// to avoid using Enumerations, walk the individual tables skipping nulls
	public Object[] keyTable;
	public int[] valueTable;
	
	int elementSize; // number of elements in the table
	int threshold;
	public IndexHashTable() {
		this(13);
	}
	public IndexHashTable(int size) {
		this.elementSize = 0;
		this.threshold = size; // size represents the expected number of elements
		int extraRoom = (int) (size * 1.75f);
		if (this.threshold == extraRoom)
			extraRoom++;
		this.keyTable = new Object[extraRoom];
		this.valueTable = new int[extraRoom];
	}
	public boolean containsKey(Object key) {
		int index = key.hashCode() % valueTable.length;
		Object currentKey;
		while ((currentKey = keyTable[index]) != null) {
			if (currentKey == key)
				return true;
			index = (index + 1) % keyTable.length;
		}
		return false;
	}
	public int get(Object key) {
		int index = key.hashCode() % valueTable.length;
		Object currentKey;
		while ((currentKey = keyTable[index]) != null) {
			if (currentKey == key)  return valueTable[index];
			index = (index + 1) % keyTable.length;
		}
		return -1;
	}
	public int put(Object key, int value) {
		int index = key.hashCode() % valueTable.length;
		Object currentKey;
		while ((currentKey = keyTable[index]) != null) {
			if (currentKey == key)  return valueTable[index] = value;
			index = (index + 1) % keyTable.length;
		}
		keyTable[index] = key;
		valueTable[index] = value;

		// assumes the threshold is never equal to the size of the table
		if (++elementSize > threshold)
			rehash();
		return value;
	}
	private void rehash() {
		IndexHashTable newHashtable = new IndexHashTable(elementSize * 2); // double the number of expected elements
		Object currentKey;
		for (int i = keyTable.length; --i >= 0;)
			if ((currentKey = keyTable[i]) != null)
				newHashtable.put(currentKey, valueTable[i]);

		this.keyTable = newHashtable.keyTable;
		this.valueTable = newHashtable.valueTable;
		this.threshold = newHashtable.threshold;
	}
	public int size() {
		return elementSize;
	}
	public String toString() {
		String s = ""; //$NON-NLS-1$
		int object;
		for (int i = 0, length = valueTable.length; i < length; i++)
			if ((object = valueTable[i]) != -1)
				s += keyTable[i] + " -> " + object + "\n"; //$NON-NLS-2$ //$NON-NLS-1$
		return s;
	}
}
