/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (9/11/00 10:31:23 PM)
 * @author:
 */
public abstract class SimpleProcessCommand extends CommandElement implements Constants {

	protected long _processId;
/**
 * SimpleProcessCommand constructor comment.
 */
public SimpleProcessCommand() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 10:32:18 PM)
 * @return long
 */
public long getProcessId() {
	return _processId;
}
/**
 * getSize method comment.
 */
public int getSize() {
	return 3*sizeofLong;
}
/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=offset;
	_context=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	_processId=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
			
	return current;
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 10:32:18 PM)
 * @param new_pid long
 */
public void setProcessId(long pid) {
	_processId = pid;
}
/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=offset;
	current=Message.writeRALongToBuffer(buffer, current, _tag);
	current=Message.writeRALongToBuffer(buffer, current, _context);
	current=Message.writeRALongToBuffer(buffer, current, _processId);

	return current;
}
}
