package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

public interface IPreemptedLogger {
	/**
	 * Suspends the current thread until the Logging Agent is monitored or the 
	 * the parameter maximum time (milliseconds) has expired.
	 *
	 * @param maxTime the maximum amount of time (milliseconds) to suspend the current thread
	 * @return true if the logger is being monitored
	 */
	public boolean waitUntilLogging(long maxTime);


	/**
	 * Checks if the Logging Agent is logging (e.g. Agent Controller is available and the Logging Agent is being monitored).
	 *
	 * @return True if the Logging Agent is logging, otherwise false.
	 */
	public boolean isLogging();
	
	/**
	 * Deregisters this Logging Agent instance from the Agent Controller.
	 */
	public void finalize();


}