/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

/**
 * Extends the HyadesNewWizard to create the Deployment.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class DeploymentNewWizard 
extends HyadesNewWizard
{
	DeploymentObjectPage artifactPage = null;
	DeploymentObjectPage locationPage = null;
	DeploymentMapPage mapPage = null;
	TPFDeployment deployment = null;
	
	/**
	 * Constructor for DeploymentNewWizard
	 */
	public DeploymentNewWizard()
	{
		super();
		setWindowTitle(TestUIPlugin.getString("WIZ_DEPLOY_TTL")); //$NON-NLS-1$
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWDEPLOYMENT));

		IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard"); //$NON-NLS-1$
		if(settings == null)
			settings = dialogSettings.addNewSection("TestSuiteNewWizard"); //$NON-NLS-1$
		setDialogSettings(settings);
		deployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	protected String getFileExtension()
	{
		return ICommonConstants.DEPLOYMENT_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL")); //$NON-NLS-1$
		getLocationPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_LOC_DSC")); //$NON-NLS-1$
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL")); //$NON-NLS-1$
		getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_ATT_DSC")); //$NON-NLS-1$
		addPage(getAttributeWizardPage());
		
		// TODO move "{0} {1}" to resource bundle.
		String pageName = TestUIPlugin.getString("W_DEPLOYMENT") + " ";
		artifactPage = new DeploymentObjectPage((pageName + TestUIPlugin.getString("W_ARTIFACTS")), deployment, Common_ConfigurationFactory.eINSTANCE.createCFGArtifact()); //$NON-NLS-1$
		artifactPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL")); //$NON-NLS-1$
		artifactPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_ART_DSC")); //$NON-NLS-1$
		addPage(artifactPage);

		locationPage = new DeploymentObjectPage((pageName + TestUIPlugin.getString("W_LOCS")), deployment, Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint()); //$NON-NLS-1$
		locationPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL")); //$NON-NLS-1$
		locationPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_LOCATION_DSC")); //$NON-NLS-1$
		addPage(locationPage);
		
		mapPage = new DeploymentMapPage((pageName + TestUIPlugin.getString("W_PAIRS")), deployment); //$NON-NLS-1$
		mapPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL")); //$NON-NLS-1$
		mapPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_MAP_DSC")); //$NON-NLS-1$
		addPage(mapPage);

	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		Resource resource = createResource(file);
		resource.getContents().add(createEObject());
		EMFUtil.save(resource);
		return true;
	}
	
	/**
	 * Creates the EObject setting the attributes based on the information
	 * the user has defined in this wizard's pages.
	 * @return a not null EObject
	 */
	protected EObject createEObject()
	{
		deployment.setName(getAttributeWizardPage().getItemName());
		
		String description = getAttributeWizardPage().getItemDescription();
		if((description != null) && (description.trim().length() > 0))
			deployment.setDescription(description);
			
		return deployment;
	}
	
	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	protected Resource createResource(IFile file)
	{
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString());
		Resource.Factory factory = EMFUtil.getResourceFactory(ICommonConstants.DEPLOYMENT_FILE_EXTENSION);
		return factory.createResource(uri);
	}

		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		if(TestUIPlugin.getInstance().getPreferenceStore().getBoolean(TestUI.OPEN_EDITOR))
			UIUtil.openEditor(file, TestUIExtension.DEPLOYMENT_EDITOR_PART_ID, false);
	}	

	public IWizardPage getNextPage(IWizardPage page)
	{
		mapPage.refresh();
		return super.getNextPage(page);
	}
	
}
