/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IExtractor;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.w3c.dom.Element;
import org.eclipse.hyades.logging.adapter.util.Messages;
/**
 * Extractor uses basic Java String searching to provide mess extraction from incoming strings.
 */
public class Extractor extends ProcessUnit implements IExtractor
{
	private boolean nestedMessages = false;
	private boolean containsLineBreaks = false;
	private boolean replaceLineBreaks = false;
	private String lineBreakSymbol = null;
	private String startPattern = null;
	private boolean includeStartPattern = false;
	private String endPattern = null;
	private boolean includeEndPattern = false;
	private String childStartPattern = null;
	private boolean includeChildStartPattern = false;
	private String childEndPattern = null;
	private boolean includeChildEndPattern = false;
	public void setNestedMessages(boolean nestedMessages)
	{
		this.nestedMessages = nestedMessages;
	}
	public boolean isNestedMessages()
	{
		return nestedMessages;
	}
	public Object[] processEventItems(Object[] msgs)
	{
		return processStrings((String[]) msgs);
	}
	public MessageString[] processStrings(String[] strings)
	{
		//TODO: over-ride this method in a concrete impl
		return new MessageString[2];
	}
	public Object[] testEventInterface(Object[] msgs) throws AdapterInvalidConfig
	{
		return testProcessStrings((String[]) msgs);
	}
	public MessageString[] testProcessStrings(String[] events)
	{
		return new MessageString[2];
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#stop()
	 */
	public void stop()
	{
		super.stop();
		clean();
	}
	/**
	 * update the configuration based on the configuration Element
	 */
	public void update() throws AdapterInvalidConfig
	{
		// first get the basic configuration set
		super.update();
		Element extractorInstance = null;
		Element element = getConfiguration();
		extractorInstance = element;
		if (extractorInstance.hasAttribute(Messages.getString("HyadesGAlineBreakSymbolAttributeName")))
			setLineBreakSymbol(
				extractorInstance.getAttribute(Messages.getString("HyadesGAlineBreakSymbolAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGAcontainsLineBreaksAttributeName")))
			setContainsLineBreaks(
				Boolean
					.valueOf(element.getAttribute(Messages.getString("HyadesGAcontainsLineBreaksAttributeName")))
					.booleanValue());
		if (element.hasAttribute(Messages.getString("HyadesGAreplaceLineBreaksAttributeName")))
			setReplaceLineBreaks(
				Boolean
					.valueOf(element.getAttribute(Messages.getString("HyadesGAreplaceLineBreaksAttributeName")))
					.booleanValue());


		if (extractorInstance.hasAttribute(Messages.getString("HyadesGADescriptionAttributeName")))
			setDescription(extractorInstance.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
		if (extractorInstance.hasAttribute(Messages.getString("HyadesGAstartPatternAttributeName")))
			setStartPattern(extractorInstance.getAttribute(Messages.getString("HyadesGAstartPatternAttributeName")));
		if (extractorInstance.hasAttribute(Messages.getString("HyadesGAendPatternAttributeName")))
			setEndPattern(extractorInstance.getAttribute(Messages.getString("HyadesGAendPatternAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGAincludeStartPatternAttributeName")))
			setIncludeStartPattern(
				Boolean
					.valueOf(element.getAttribute(Messages.getString("HyadesGAincludeStartPatternAttributeName")))
					.booleanValue());
		if (element.hasAttribute(Messages.getString("HyadesGAincludeEndPatternAttributeName")))
			setIncludeEndPattern(
				Boolean
					.valueOf(element.getAttribute(Messages.getString("HyadesGAincludeEndPatternAttributeName")))
					.booleanValue());
	}
	public void setContainsLineBreaks(boolean containsLineBreaks)
	{
		this.containsLineBreaks = containsLineBreaks;
	}
	public boolean getContainsLineBreaks()
	{
		return containsLineBreaks;
	}
	public void setReplaceLineBreaks(boolean replaceLineBreaks)
	{
		this.replaceLineBreaks = replaceLineBreaks;
	}
	public boolean getReplaceLineBreaks()
	{
		return replaceLineBreaks;
	}

	public void setLineBreakSymbol(String newLineBreakSymbol)
	{
		lineBreakSymbol = newLineBreakSymbol;
	}
	public String getLineBreakSymbol()
	{
		return lineBreakSymbol;
	}
	public void setStartPattern(String startPattern)
	{
		this.startPattern = startPattern;
	}
	public String getStartPattern()
	{
		return startPattern;
	}
	public void setIncludeStartPattern(boolean includeStartPattern)
	{
		this.includeStartPattern = includeStartPattern;
	}
	public boolean getIncludeStartPattern()
	{
		return includeStartPattern;
	}
	public void setEndPattern(String endPattern)
	{
		this.endPattern = endPattern;
	}
	public String getEndPattern()
	{
		return endPattern;
	}
	public void setIncludeEndPattern(boolean includeEndPattern)
	{
		this.includeEndPattern = includeEndPattern;
	}
	public boolean getIncludeEndPattern()
	{
		return includeEndPattern;
	}
	public void setChildStartPattern(String childStartPattern)
	{
		this.childStartPattern = childStartPattern;
	}
	public String getChildStartPattern()
	{
		return childStartPattern;
	}
	public void setIncludeChildStartPattern(boolean includeChildStartPattern)
	{
		this.includeChildStartPattern = includeChildStartPattern;
	}
	public boolean getIncludeChildStartPattern()
	{
		return includeChildStartPattern;
	}
	public void setChildEndPattern(String childEndPattern)
	{
		this.childEndPattern = childEndPattern;
	}
	public String getChildEndPattern()
	{
		return childEndPattern;
	}
	public void setIncludeChildEndPattern(boolean includeChildEndPattern)
	{
		this.includeChildEndPattern = includeChildEndPattern;
	}
	public boolean getIncludeChildEndPattern()
	{
		return includeChildEndPattern;
	}
}
