/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.sample.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.wizard.INewTestCaseWizard;

/**
 * @author marcelop
 * @since 
 */
public class TestCaseType1 
extends Wizard implements INewTestCaseWizard
{
	private TPFTestSuite testSuite;
	private NameWizardPage nameWizardPage;
	
	/**
	 * Constructor for TestCaseType1
	 */
	public TestCaseType1()
	{
		super();
		setWindowTitle("New Test Case");
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection)
	{
		testSuite = (TPFTestSuite)selection.getFirstElement();
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		nameWizardPage = new NameWizardPage("namePage");
		nameWizardPage.setTitle("Type1 Test Case");
		nameWizardPage.setDescription("Defines the name of the new test case\nof the test suite '" + testSuite.getName() + "'.");
		addPage(nameWizardPage);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		TPFTestCase testCase = Common_TestprofileFactory.eINSTANCE.createTPFTestCase();
		testCase.setName(nameWizardPage.getTestCaseName());
		testCase.setType("testCaseType1");
		
		testSuite.getTestCases().add(testCase);
		
		return true;
	}
}
