/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWT;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.*;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
* CONTEXT_ID tvpp0000 for Monitors View preference page
*/

/*
 * The page for setting java plugin preferences.
 */
public class TraceViewPreferencePage extends PreferencePage
									 implements IWorkbenchPreferencePage
{
	private TraceViewOptionsUI _options;

	public TraceViewPreferencePage()
	{
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());

	}
	protected Control createContents(Composite parent)
	{
		Composite composite= new Composite(parent, SWT.NONE);	
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".tvpp0000");
		
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 5;	
		layout.numColumns= 1;		
		composite.setLayout(layout);
		
		_options = new TraceViewOptionsUI();
		_options.createControl(composite);

		return composite;
	}
/**
 * Returns preference store that belongs to the our plugin.
 * This is important because we want to store
 * our preferences separately from the desktop.
 *
 * @return the preference store for this plugin
 */
protected IPreferenceStore doGetPreferenceStore() {
	return UIPlugin.getDefault().getPreferenceStore();
}
	public void init(IWorkbench workbench) {
	}
/**
 * Does anything necessary because the default button has been pressed.
 */
protected void performDefaults() {
	super.performDefaults();
	_options.initializeDefaults();

	updateTraceView();
}
/**
 * Do anything necessary because the OK button has been pressed.
 *
 * @return whether it is okay to close the preference page
 */
public boolean performOk() {
	storeValues();
	updateTraceView();
	UIPlugin.getDefault().savePluginPreferences();
	return true;
}
/**
 * Stores the values of the controls back to the preference store.
 */
private void storeValues()
{
	_options.storeValues();
}
/**
 * Insert the method's description here.
 * Creation date: (5/11/2001 11:41:01 AM)
 */
private void updateTraceView()
{
	//reset filters on all trace views
	final IWorkbenchWindow window= UIPlugin.getActiveWorkbenchWindow();
	if(window == null)
	  return ;

	IWorkbenchPage[] persps = window.getPages();
	for(int idx=0; idx<persps.length; idx++)
	{
		if(persps[idx].getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE))
		{//trace perspective
			IWorkbenchPage page = persps[idx];

			IViewPart view = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
			if(view != null)
			{
				PDProjectExplorer viewer = (PDProjectExplorer) view;
				viewer.updateActionBars();
				viewer.refresh();
			}
		}
	}
	
}
}
