/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.swt.widgets.*;
import org.eclipse.core.resources.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;

/*
* CONTEXT_ID omwp0000 for open monitor wizard page
*/

public class OpenMonitorWizardPage extends NewMonitorWizardPage {
	public OpenMonitorWizardPage(String name, IResource selection) {
		super(name, selection);
		setTitle(UIPlugin.getResourceString("MONITOR_PROPERTIES_TITLE"));
		setDescription(UIPlugin.getResourceString("MONITOR_PROPERTIES_DESC"));
	}
	public void createControl(Composite parent) {
		super.createControl(parent);

		_locationUI.setEnabled(false);

		populateData();
		setErrorMessage(null);
		setPageComplete(true);

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			UIPlugin.getPluginId() + ".omwp0000");
	}
	public boolean finish() {
		return true;

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/05/2000 3:17:53 PM)
	 */
	protected void populateData() {
		TRCMonitor monitor = ((OpenMonitorWizard) getWizard()).getMonitor();

		if (monitor == null)
			return;

		_locationUI.getMonitor().setText(monitor.getName());

	}
}
