/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Nov 20, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.log.ui.internal.navigator.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogLabelProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogSelectionWizardPage extends WizardPage implements SelectionListener{
	
	private DoubleList doubleList;
	private IStructuredSelection sel;
	private Text txtName;
	private Set existingCorrNames;
	
	/**
	 * @param pageName
	 */
	protected LogSelectionWizardPage(String pageName, IStructuredSelection sel) {
		super(pageName);
		setTitle(LogUIPlugin.getResourceString("STR_LOGSEL_PAGE_TITLE"));	
		setDescription(LogUIPlugin.getResourceString("STR_LOGSEL_PAGE_DESC"));
		setImageDescriptor(LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_NEW_CORR_WIZ));		
		
		this.sel = sel ;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);
		composite.setLayout(new GridLayout());
		GridData data = GridUtil.createFill();
		data.widthHint  = 370;
		
		composite.setLayoutData(data);
		
		createNameGroup(composite);
		
		doubleList =
			new DoubleList(
				composite,
				SWT.NULL,			
				LogUIPlugin.getResourceString("STR_AVAILABLE_LOGS"),
				LogUIPlugin.getResourceString("STR_SELECTED_LOGS"));
		doubleList.createControl();

		initializeValues();
		doubleList.addSelectionListener(this);
		setControl(composite);
	}
	
	public String getName(){
		return txtName.getText();
	}
	
	public List getLogFiles(){
		return doubleList.getTargetItems();
	}

	private void createNameGroup(Composite composite){
		Composite locationGrp = new Composite(composite, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createHorizontalFill();
		data.widthHint = 300;   	
		locationGrp.setLayout(layout);
		locationGrp.setLayoutData(data);
					
		Label lblName = new Label(locationGrp, SWT.NONE);
		data = new GridData();		
		lblName.setLayoutData(data);				
		lblName.setText(LogUIPlugin.getResourceString("STR_NEW_CORR_NAME"));
	
		// correlation name entry field
		txtName = new Text(locationGrp, SWT.BORDER);
		data = GridUtil.createHorizontalFill();		
		txtName.setLayoutData(data);
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();		
		txtName.setText("NewCorrelation ("+ (store.getInt("corr_nr")+1)+")");

		txtName.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e){
				if(existingCorrNames!=null && existingCorrNames.contains(txtName.getText())){
					setErrorMessage(LogUIPlugin.getResourceString("STR_CORR_EXISTS_MSG"));					
				}else{
					setErrorMessage(null);					
				}
				setPageComplete(isPageComplete());
			}
		});
		
		WorkbenchHelp.setHelp(txtName, ContextIds.NEW_CORR_WIZARD_CORRNAME);
	}
	
	private void initializeValues() {
		
		List source = new ArrayList();
		List target = new ArrayList();
		source = populateLogFilesList();
		doubleList.removeAll();
		
		doubleList.initializeSourceList((ArrayList)source);
		doubleList.initializeTargetList((ArrayList)target);

		if(sel != null && !sel.isEmpty()){
			Object element = null;
			for (Iterator iter = sel.iterator(); iter.hasNext();) {
				element = iter.next();				
				if(element!=null && element instanceof TRCAgentProxy){
					doubleList.getSourceItems().remove(element);
					doubleList.getTargetItems().add(element);
				}
			}
			doubleList.refreshViews();
		}		
	}

	
	private List populateLogFilesList() {

		IWorkbenchPage page = null;
		IViewPart navigator = null;
		IWorkbenchWindow[] windows = LogUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
		for (int i = 0; i < windows.length; i++) {
			IWorkbenchWindow window = windows[i];
			IWorkbenchPage[] pages = window.getPages();
			for (int j = 0; j < pages.length; j++) {
				page = pages[j];
				if(page!=null && (navigator=page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW))!=null){
					break;
				}
			}
		}		
		List logList = new ArrayList();
		if(navigator!=null && navigator instanceof LogNavigator){
			logList.addAll(EMFUtil.getLogAgentsFromResourceSet(HierarchyResourceSetImpl.getInstance()));			
			loadCorrelationContainerProxyNames(((LogNavigator)navigator).getContentProvider());			
		}else{
			
			logList.addAll(loadLogFiles());
			
		}		
		return logList;
	}
	
	/**
	 * @param provider
	 */
	private void loadCorrelationContainerProxyNames(LogContentProvider provider) {
		
		if(existingCorrNames==null){
			existingCorrNames = new HashSet();
		}
		if(provider!=null){
			Object[] correlations = provider.getChildren(provider.getCorrelationFolder());
			for (int i = 0; i < correlations.length; i++) {
				existingCorrNames.add(((CorrelationContainerProxy)correlations[i]).getName());
			}
		}		
	}

	
	private List loadLogFiles(Object[] eObjects) {
		
		int size = eObjects.length;
		List log_agents = new ArrayList();
		
		for(int idx=0; idx<size;idx++){
			Object obj = eObjects[idx];
			if (obj instanceof TRCMonitor){
				appendCorrelationContainerProxyNames(((TRCMonitor)obj).getCorrelationContainerProxies());				
				List nodes = ((TRCMonitor)obj).getNodes();					
				int nodes_size = nodes.size();
				for(int i=0; i < nodes_size; i++){
					List processes = ((TRCNode)nodes.get(i)).getProcessProxies();
					for(int j=0; j < processes.size(); j++){
						
						List agents = ((TRCProcessProxy)processes.get(j)).getAgentProxies();							
						for(int k=0; k < agents.size(); k++){
							TRCAgentProxy agent = (TRCAgentProxy)agents.get(k);
							if(agent.getType().equals(HyadesConstants.LOG_AGENT_TYPE)){
								log_agents.add(agent);
							}
						}				
					}
				}					
			}
		}			
		return log_agents;
	}

	/**
	 * @param list
	 */
	private void appendCorrelationContainerProxyNames(List list) {

		if(existingCorrNames==null){
			existingCorrNames = new HashSet();
		}

		for (Iterator iter = list.iterator(); iter.hasNext();) {
			CorrelationContainerProxy element = (CorrelationContainerProxy)iter.next();
			if(!existingCorrNames.contains(element.getName())){
				existingCorrNames.add(element.getName());
			}
			
		}
		
		
	}
	
	private List loadLogFiles(){
		
		String[] extensions = new String[]{TraceConstants.MONITOR_EXT};
		Map filesByExtension = ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), extensions, null);
		Object[] resourceSetObj = EMFUtil.loadMonitorsFromResourceSet(HierarchyResourceSetImpl.getInstance());
		List log_agents = new ArrayList();
		log_agents.addAll(loadLogFiles(resourceSetObj));
		
		for(Iterator i = ((List)filesByExtension.get(TraceConstants.MONITOR_EXT)).iterator(); i.hasNext();)
		{
			Object[] eObjects = EMFUtil.load(HierarchyResourceSetImpl.getInstance(), (IFile)i.next());
			for (Iterator iter = loadLogFiles(eObjects).iterator(); iter.hasNext();) {
				Object element = iter.next();
				if(!log_agents.contains(element)){
					log_agents.add(element);
				}
				
			}
		}
		
		return log_agents;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		
		setPageComplete(isPageComplete());		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
		
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizardPage#isPageComplete()
	 */
	public boolean isPageComplete() {
		return (doubleList.getTargetItems().size()>0 && txtName.getText().length()>0 && existingCorrNames!=null && !existingCorrNames.contains(txtName.getText()));
	}
	
	class DoubleList
	{
	  Group group;
	  Composite groupWidget;  

	  private TableViewer sourceList;
	  private TableViewer targetList;
	  private Label targetListLabel;
	  private Label sourceListLabel;
	  private List sourceContent = new ArrayList();
	  private List targetContent = new ArrayList();  

	  private  Button    add;
	  private  Button    remove;
	  private  Button    addAll;
	  private  Button    removeAll;
  	  private  List listeners = new ArrayList(2);
  	 
  	  private TableLabelProvider labelProvider;
	  private Composite parent;
	  private int style;
	  private String sourceText;
	  private String targetText;

	  class WidgetListener implements SelectionListener
	  {
		public void widgetDefaultSelected(SelectionEvent e){	
			if(e.widget==sourceList.getTable() && !sourceList.getSelection().isEmpty()){
				IStructuredSelection sel = (IStructuredSelection)sourceList.getSelection();
				 for (Iterator i = sel.iterator(); i.hasNext();)
				 {
				   Object item = i.next();
				   targetContent.add(item);
				   sourceContent.remove(item);
				 }
				 sourceList.setSelection(StructuredSelection.EMPTY);		 
				 refreshViews();
				 fireSelectionNotification(e);					
			}
			
			if(e.widget==targetList.getTable() && !targetList.getSelection().isEmpty()){
				IStructuredSelection sel = (IStructuredSelection)targetList.getSelection();
				 for (Iterator i = sel.iterator(); i.hasNext();)
				 {
				   Object item = i.next();
				   sourceContent.add(item);
				   targetContent.remove(item);
				 }
				 targetList.setSelection(StructuredSelection.EMPTY);		 
				 refreshViews();
				 fireSelectionNotification(e);					
			}
			
		}
	
		public void widgetSelected(SelectionEvent e) 
		{

			if(e.widget == add)
			{
			 IStructuredSelection sel = (IStructuredSelection)sourceList.getSelection();
			  for (Iterator i = sel.iterator(); i.hasNext();)
			  {
				Object item = i.next();
				targetContent.add(item);
				sourceContent.remove(item);
			  }
			  sourceList.setSelection(StructuredSelection.EMPTY);		 
          
			}
			else if(e.widget == addAll)
			{
			  for (int i=0; i < sourceContent.size(); i++)
			  {
				 Object item = sourceContent.get(i);
				 targetContent.add(item);
			  }
			  sourceContent.clear();         
			}
			else if(e.widget == remove)
			{
			  IStructuredSelection sel = (IStructuredSelection)targetList.getSelection();
			  
			  for (Iterator i = sel.iterator(); i.hasNext();)
			  {
				Object item = i.next();
				sourceContent.add(item);
				targetContent.remove(item);
			  }
			  targetList.setSelection(StructuredSelection.EMPTY);
           
			}
			else if(e.widget == removeAll)
			{
			  for (int i=0; i < targetContent.size(); i++)
			  {
				 Object item = targetContent.get(i);
				 sourceContent.add(item);
			  }
			  targetContent.clear();
         
			}else if(e.widget instanceof Table){
				TableItem[] sel = ((Table)e.widget).getSelection();
				if(sel!=null && sel.length>0){
					((Table)e.widget).setToolTipText(sel[0].getText());	
				}
			}
				
			refreshViews();
			fireSelectionNotification(e);
		}	
	  }
	  
	  class TableContentProvider implements IStructuredContentProvider{
	
		private List tableContents = new ArrayList(0);	
		
		/* (non-Javadoc)
		   * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		   */
		  public Object[] getElements(Object inputElement) {			
			  return tableContents.toArray();
		  }

		  /* (non-Javadoc)
		   * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		   */
		  public void dispose() {
			//tableContents.clear();
		  }

		  /* (non-Javadoc)
		   * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		   */
		  public void inputChanged(
			  Viewer viewer,
			  Object oldInput,
			  Object newInput) {
			  	tableContents = (List)newInput;				
		  }

	  }
	  
	  class TableLabelProvider extends LabelProvider implements ITableLabelProvider{
		 
		private LogLabelProvider logLabelProvider;
		
		public TableLabelProvider(){
			logLabelProvider = new LogLabelProvider();
		}
		
		public Image getColumnImage(Object element, int columnIndex) {
			
			if(columnIndex==0){

				return logLabelProvider.getImage(element);

			}
			return null; 
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) {

			if(columnIndex==1){
				return logLabelProvider.getText(element);
			}
			return "";
		}
				
		/*
		 * @see IBaseLabelProvider#dispose()
		 */
		public void dispose() {			
			super.dispose();
		}
	  
	  }
	  
	  public DoubleList(Composite parent, int style,
						 String sourceText, String targetText)
	  {
	   		this.parent = parent;
	   		this.style = style;
	   		this.sourceText = sourceText;
	   		this.targetText = targetText;
		///////////////////
	  }  
	  
	  public Control createControl(){
		group = new Group(parent, style);
		group.setText("");
	
		GridLayout layout= new GridLayout();
		//layout.verticalSpacing= -10;
		layout.horizontalSpacing= 0;    
		group.setLayout(layout);
		group.setLayoutData(GridUtil.createFill());
	
		createDoubleList(group, sourceText, targetText);

		//add listeners
		WidgetListener listener = new WidgetListener(); 
		add.addSelectionListener(listener);
		remove.addSelectionListener(listener);
		addAll.addSelectionListener(listener);;
		removeAll.addSelectionListener(listener);
		sourceList.getTable().addSelectionListener(listener);
		targetList.getTable().addSelectionListener(listener);
		
		WorkbenchHelp.setHelp(sourceList.getTable(), ContextIds.NEW_CORR_WIZARD_LOGS);
		WorkbenchHelp.setHelp(targetList.getTable(), ContextIds.NEW_CORR_WIZARD_LOGS);
		return group; 	  
	  } 
	  
	  public void refreshViews(){
	  	sourceList.refresh();
	  	targetList.refresh();
	  }
	  
	  /**
	  * Create double list components
	  */
	  public void createDoubleList(Composite parent, 
						 String sourceText, String targetText)    
	  {
		  	  
		groupWidget = parent;

		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		groupWidget.setLayout(layout);

		createTableGroup(groupWidget, sourceText, true);		
 
		createButtonGroup(groupWidget);		
			
		createTableGroup(groupWidget, targetText, false);		
		
		labelProvider = new TableLabelProvider();
	
	  }  

		// Initialize the list on the left.
		public void initializeSourceList(List source) {			
			sourceContent.addAll(source);
			sourceList.setContentProvider(new TableContentProvider());
			sourceList.setLabelProvider(labelProvider);
			sourceList.setInput(sourceContent);
			if(source.size()>0){
				sourceList.setSelection(new StructuredSelection(source.get(0)));
			}			
		}

		// Initialize the list on the right.
		public void initializeTargetList(List target) {
			targetContent.addAll(target);
			targetList.setContentProvider(new TableContentProvider());
			targetList.setLabelProvider(labelProvider);
			targetList.setInput(targetContent);		
		}

	  public void removeAll()
	  {
		  targetContent.clear();
		  sourceContent.clear();   
	  } 
	  
	  public List getSourceItems(){
	  	return sourceContent;
	  }
	  
	  public List getTargetItems(){
	  	return targetContent;
	  }
	  
	  public void addSelectionListener(SelectionListener listener){
	
		if(!listeners.contains(listener)){
			listeners.add(listener);
		}  
	  }
  
	  public void removeSelectionListener(SelectionListener listener){
		listeners.remove(listener);
	  }
	  
	  public void fireSelectionNotification(SelectionEvent e){

		for (int i = 0; i < listeners.size(); i++) {
			((SelectionListener)listeners.get(i)).widgetSelected(e);
		}	   
	  }
	  
	 private void createTableGroup(Composite parent, String text, boolean source){
		Composite tableGroup =  new Composite (parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		tableGroup.setLayout(layout);
		tableGroup.setLayoutData(GridUtil.createFill());
		
		Label label = new Label (tableGroup, SWT.NONE);
		label.setText(text);
		GridData spec = new GridData();		
		spec.horizontalAlignment = GridData.FILL;
		label.setLayoutData(spec);
		 
		if(source){
			sourceList = new TableViewer(createTable(tableGroup)); 
			sourceList.getTable().setLayoutData(GridUtil.createFill());
		}else{
			targetList = new TableViewer(createTable(tableGroup)); 
			targetList.getTable().setLayoutData(GridUtil.createFill());		
		}
	 
	 }
	 
	 private Table createTable(Composite parent){
		Table table = new Table(parent, SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL|SWT.FULL_SELECTION|SWT.SINGLE);
		GridData tblData = GridUtil.createFill();
		tblData.heightHint = 75;
		tblData.widthHint = 150;	
		table.setLayoutData(tblData);

		TableColumn column0= new TableColumn(table, SWT.NONE); 
		TableColumn column1= new TableColumn(table, SWT.NONE);		
		
		ColumnLayoutData c0Layout = new ColumnWeightData(0, false);		
		ColumnLayoutData c1Layout = new ColumnWeightData(1, true);

		// set columns in Table layout
		TableLayout tblLayout = new TableLayout();
		tblLayout.addColumnData(c0Layout);
		tblLayout.addColumnData(c1Layout);

		table.setLayout(tblLayout);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		return table;
	 
	 }
	 
	 private void createButtonGroup(Composite groupWidget){
		Composite buttonGroup = new Composite (groupWidget, SWT.NULL);   
		GridLayout blayout = new GridLayout();
		blayout.numColumns = 1;
		buttonGroup.setLayout(blayout);     
	
		Label label = new Label (buttonGroup, SWT.PUSH);
		label.setText("");
		GridData spec = new GridData();
		spec.grabExcessVerticalSpace = true;
		spec.verticalAlignment = GridData.FILL;
		label.setLayoutData(spec);
	
		add = new Button(buttonGroup, SWT.PUSH);
		add.setText(LogUIPlugin.getResourceString("LEFT_TO_RIGHT"));
		spec = new GridData();
		spec.horizontalAlignment = GridData.FILL;
		add.setLayoutData(spec);

		remove = new Button(buttonGroup, SWT.PUSH);
		remove.setText(LogUIPlugin.getResourceString("RIGHT_TO_LEFT"));
		spec = new GridData();
		spec.horizontalAlignment = GridData.FILL;
		remove.setLayoutData(spec);
		
		new Label(buttonGroup, SWT.NONE);
		
		addAll = new Button(buttonGroup, SWT.PUSH);
		addAll.setText(LogUIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
		spec = new GridData();
		spec.horizontalAlignment = GridData.FILL;
		addAll.setLayoutData(spec);
	
		removeAll = new Button(buttonGroup, SWT.PUSH);
		removeAll.setText(LogUIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
		spec = new GridData();
		spec.horizontalAlignment = GridData.FILL;
		removeAll.setLayoutData(spec);

		Label label1 = new Label (buttonGroup, SWT.PUSH);
		label1.setText("");
		spec = new GridData();
		spec.grabExcessVerticalSpace = true;
		spec.verticalAlignment = GridData.FILL;
		label.setLayoutData(spec);
		
		WorkbenchHelp.setHelp(add, ContextIds.NEW_CORR_WIZARD_LOGS);
		WorkbenchHelp.setHelp(remove, ContextIds.NEW_CORR_WIZARD_LOGS);
		WorkbenchHelp.setHelp(addAll, ContextIds.NEW_CORR_WIZARD_LOGS);
		WorkbenchHelp.setHelp(removeAll, ContextIds.NEW_CORR_WIZARD_LOGS);
	 
	 }
	 
	}
 

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#dispose()
	 */
	public void dispose() {
		doubleList.removeSelectionListener(this);
		if(existingCorrNames!=null)	
			existingCorrNames.clear();
		super.dispose();
	}

}
