/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;

/**
 * This class aims to populate a Node (host) Interaction UML2 Sequence Diagram.
 */
public class NodeInteractions extends TraceInteractions {
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	protected EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getProcess().getAgent().getAgentProxy().getProcessProxy().getNode(); // TRCNode
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	protected int getLifeLineCategory(EObject to) {
		return CATEGORY_NODE;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	protected String getLifeLineTitle(EObject to, boolean long_) {
		TRCNode node = (TRCNode)to;
		return node.getName(); //$NON-NLS-1$
	}

	/**
	 * This is the nose interactions, nothing else
	 */
	public String getFinalTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_NODE_INTERACTION"); //$NON-NLS-1$
	}
	
}
