/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.provider;

import java.util.ArrayList;

/**
 * Sequence Diagram loaders which implement this class provide the
 * actions filtering the sequence diagram.<br>
 * This interface also allow the implementor to set wich graph nodes are supporting filtering
 * (thanks to ISDGraphNodeSupporter extension).<br>
 * 
 * Action provider are associated to a Sequence Diagram SDWidget calling 
 * <code>SDViewer.setSDFilterProvider</code><br>
 * 
 * Filters to be applied to be managed by the loader in an ArrayList of FilterCriteria.<br>
 */
public interface ISDFilterProvider extends ISDGraphNodeSupporter {

	/**
	 * Called when the Filter dialog box OK button is pressed
	 * @param toApply user selection made in the dialog box
	 * @return true if the filter applied
	 */
	public boolean filter(ArrayList filters);
	
	/**
	 * @return the list of the current FilterCriterias to be displayed in the dialog
	 */
	public ArrayList getCurrentFilters();
}
