/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.drawings.IImage;

/**
 * LifelineCategories is used to assign additional description for 
 * lifelines of the same type. This consiste in providing a type name and an icon.
 * The icon will be displayed in the rectangle which cantains the lifeline name.
 * The category name is only display in the lifeline tooltip.
 */
public class LifelineCategories {
	
	/**
	 * The category name
	 */
	protected String name = null;
	/**
	 * The category image
	 */
	protected IImage categoryImage = null;
	
	/**
	 * Returns the category name
	 * @return the category name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the category name
	 * @param string the name
	 */
	public void setName(String string) {
		name = string;
	}
	   
	/**
	 * Returns the category icon
	 * @return the category icon
	 */
	public IImage getImage()
	{
		return categoryImage;
	}
	
	/**
	 * Set the category icon
	 * @param image the icon
	 */
	public void setImage(IImage image)
	{
		categoryImage = image;
	}
}
