package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The CreateSituation deals with the situations documenting when a component creates 
 * an entity. Messages telling that a document was created, or a file was created, or 
 * an EJB was created all fall into this category. Existing message include words like 
 * was created, about to create, and now exists, for example:
 * 
 * <code>
 * ADMR0009I: Document cells/flatfootNetwork/applications/Dynamic Cache Monitor.ear/Dynamic Cache Monitor.ear was created
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface ICreateSituation extends ISituationType {

    /**
     * Returns the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a situation 
     * that caused the situation to be reported.  The successDisposition is a string 
     * with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned successDisposition.
     * @since 1.0.1
     */
    public String getSuccessDisposition();

    /**
     * Sets the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a situation 
     * that caused the situation to be reported.  The successDisposition is a string 
     * with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param successDisposition The successDisposition to be set.
     * @since 1.0.1
     */
    public void setSuccessDisposition(String successDisposition);
}
