/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class DirectedGraph {
    private Object[] objList = null;
    private Object[][] adjMat = null;
    private int nVerts = -1;
    private Hashtable threadNumbers = null;
    private Hashtable _threads = null;
    private Hashtable _reversedTid = null;
    private boolean deadlockExists = false;

    public DirectedGraph(Hashtable _t) {
        this._threads = _t;
        int maxThreads = this._threads.size();
        this.objList = new Object[maxThreads];
        this.adjMat = new Object[maxThreads][maxThreads];
        this.nVerts = 0;
        for (int j = 0; j < maxThreads; ++j) {
            for (int k = 0; k < maxThreads; ++k) {
                this.adjMat[j][k] = null;
            }
        }
        this.threadNumbers = new Hashtable();
    }

    public void addVertex(Object thd) {
        this.threadNumbers.put(thd, new Integer(this.nVerts));
        this.objList[this.nVerts++] = thd;
    }

    public void addEdge(Object edge, Object start, Object end) {
        int startInt = (Integer)this.threadNumbers.get(start);
        int endInt = (Integer)this.threadNumbers.get(end);
        this.adjMat[startInt][endInt] = edge;
    }

    public void displayVertex(int v) {
        System.out.print(((Thd)this.objList[v])._threadId);
    }

    public void findCircularPattern() {
        int orig_nVerts = this.nVerts;
        while (this.nVerts > 0) {
            int currentVertex = this.noSuccessors();
            if (currentVertex == -1) {
                return;
            }
            this.deleteVertex(currentVertex);
        }
    }

    public int noSuccessors() {
        for (int row = 0; row < this.nVerts; ++row) {
            boolean isEdge = false;
            for (int col = 0; col < this.nVerts; ++col) {
                if (this.adjMat[row][col] == null) continue;
                isEdge = true;
                break;
            }
            if (isEdge) continue;
            return row;
        }
        return -1;
    }

    public void deleteVertex(int delVert) {
        if (delVert != this.nVerts - 1) {
            for (int j = delVert; j < this.nVerts - 1; ++j) {
                this.objList[j] = this.objList[j + 1];
            }
            for (int row = delVert; row < this.nVerts - 1; ++row) {
                this.moveRowUp(row, this.nVerts);
            }
            for (int col = delVert; col < this.nVerts - 1; ++col) {
                this.moveColLeft(col, this.nVerts - 1);
            }
        } else {
            for (int i = 0; i < this.nVerts; ++i) {
                this.adjMat[delVert][i] = null;
                this.adjMat[i][delVert] = null;
            }
        }
        --this.nVerts;
    }

    private void moveRowUp(int row, int length) {
        for (int col = 0; col < length; ++col) {
            this.adjMat[row][col] = this.adjMat[row + 1][col];
            this.adjMat[row + 1][col] = null;
        }
    }

    private void moveColLeft(int col, int length) {
        for (int row = 0; row < length; ++row) {
            this.adjMat[row][col] = this.adjMat[row][col + 1];
            this.adjMat[row][col + 1] = null;
        }
    }

    public void debugPrint() {
        int i;
        System.out.println("<p>Printing Graph:---------------------</p><br><br>");
        System.err.println("<table>");
        for (i = 0; i < this.adjMat.length; ++i) {
            System.err.println("\t<tr><td>" + i + "</td><td>" + ((Thd)this.objList[i])._name + "</td></tr>");
        }
        System.err.println("</table>");
        System.err.println("<table>");
        System.err.println("\t<tr>");
        System.err.print("<td>&nbsp;</td>");
        for (i = 0; i < this.adjMat.length; ++i) {
            System.err.print("<td>[" + i + "]</td>");
        }
        System.err.println("\t</tr>");
        for (i = 0; i < this.adjMat.length; ++i) {
            System.err.println("\t<tr>");
            System.err.print("<td>[" + i + "]</td>");
            for (int j = 0; j < this.adjMat[i].length; ++j) {
                if (this.adjMat[i][j] == null) {
                    System.err.print("<td>-</td>");
                    continue;
                }
                System.err.print("<td>" + ((Monitor)this.adjMat[i][j])._name + "</td>");
            }
            System.err.println("\t</tr>");
        }
        System.err.println("</table>");
    }

    public void debugPrint(String filename) {
        int i;
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("IO Error:: Printing to err stream anyway.");
            p = System.err;
        }
        p.println("<p>Printing Graph:---------------------</p><br><br>");
        p.println("<table>");
        for (i = 0; i < this.adjMat.length; ++i) {
            p.println("\t<tr><td>" + i + "</td><td>" + ((Thd)this.objList[i])._name + "</td></tr>");
        }
        p.println("</table>");
        p.println("<table>");
        p.println("\t<tr>");
        p.print("<td>&nbsp;</td>");
        for (i = 0; i < this.adjMat.length; ++i) {
            p.print("<td>[" + i + "]</td>");
        }
        p.println("\t</tr>");
        for (i = 0; i < this.adjMat.length; ++i) {
            p.println("\t<tr>");
            p.print("<td>[" + i + "]</td>");
            for (int j = 0; j < this.adjMat[i].length; ++j) {
                if (this.adjMat[i][j] == null) {
                    p.print("<td>-</td>");
                    continue;
                }
                p.print("<td>" + ((Monitor)this.adjMat[i][j])._name + "</td>");
            }
            p.println("\t</tr>");
        }
        p.println("</table>");
    }

    public Object[] getObjectList() {
        return this.objList;
    }

    public Object[][] getResultMatrix() {
        return this.adjMat;
    }

    public Object getObjectAt(int i, int j) {
        if (this.adjMat != null && i < this.adjMat.length && j < this.adjMat[0].length) {
            return this.adjMat[i][j];
        }
        return null;
    }

    public Object getObjectAt(Integer i, Integer j) {
        return this.getObjectAt((int)i, (int)j);
    }

    public Object getObjListObjectAt(int i) {
        if (this.objList != null && i < this.objList.length) {
            return this.objList[i];
        }
        return null;
    }

    public Object getObjListObjectAt(Integer i) {
        return this.getObjListObjectAt((int)i);
    }

    public Vector getNotNullPairs() {
        HashMap<Integer, Integer> cyclicHelper = new HashMap<Integer, Integer>();
        Vector tempResult = new Vector();
        tempResult.add(new Vector());
        Vector<String> result = null;
        ((Vector)tempResult.get(0)).add("The following threads appear to be waiting on themselves.\nCheck to see if the application is simply in a timed wait or if it is going \nto wait indefinitely.  Further information can be found by looking in the \nOverall Thread Analysis section of this tool.\n");
        if (this.adjMat != null) {
            int selfWaiterCount = 0;
            for (int i = 0; i < this.adjMat.length; ++i) {
                for (int j = 0; j < this.adjMat[0].length; ++j) {
                    if (this.adjMat[i][j] == null) continue;
                    if (i == j) {
                        ((Thd)this.objList[i]).setSelfWaiter(true);
                        if (((Thd)this.objList[i]).waitingForWork()) continue;
                        ((Vector)tempResult.get(0)).add("Single-threaded waiter " + ++selfWaiterCount + ":\n" + "\"" + ((Thd)this.objList[i])._name + "\" (TID:" + this._reversedTid.get(((Thd)this.objList[i])._threadId) + ") is waiting on " + ((Monitor)this.adjMat[i][j])._name + "\n");
                        continue;
                    }
                    cyclicHelper.put(new Integer(i), new Integer(j));
                }
            }
            Set keyset = cyclicHelper.keySet();
            Iterator itr = keyset.iterator();
            Integer i = null;
            Vector tempResultSet = new Vector();
            tempResultSet.add(new Hashtable());
            if (itr.hasNext()) {
                i = (Integer)itr.next();
            }
            int currentTable = 0;
            Integer value = null;
            while (!cyclicHelper.isEmpty()) {
                value = (Integer)cyclicHelper.get(i);
                ((Hashtable)tempResultSet.get(currentTable)).put(i, value);
                cyclicHelper.remove(i);
                i = value;
                if ((Integer)cyclicHelper.get(i) != null || cyclicHelper.isEmpty()) continue;
                itr = keyset.iterator();
                i = (Integer)itr.next();
                tempResultSet.add(++currentTable, new Hashtable());
            }
            Vector<String> deadlockResults = new Vector<String>();
            Hashtable h = null;
            for (int k = 0; k < tempResultSet.size(); ++k) {
                itr = null;
                h = (Hashtable)tempResultSet.get(k);
                itr = h.keySet().iterator();
                Integer first = null;
                if (itr.hasNext()) {
                    deadlockResults.add("Multi-threaded deadlock " + (k + 1) + ":\n");
                    first = (Integer)itr.next();
                    if (!((Thd)this.objList[first]).isSelfWaiter()) {
                        while (itr.hasNext()) {
                            i = (Integer)itr.next();
                            if (!((Thd)this.objList[i]).isSelfWaiter()) continue;
                            first = i;
                            break;
                        }
                    }
                }
                i = null;
                while (h.size() > 0) {
                    i = i == null ? first : value;
                    value = (Integer)h.get(i);
                    h.remove(i);
                    if (((Thd)this.objList[i]).isSelfWaiter()) {
                        deadlockResults.add("Thread \"" + ((Thd)this.objList[i.intValue()])._name + "\" is a self-waiter.  As a result, this deadlock is NON-circular.\n");
                    }
                    deadlockResults.add("\"" + ((Thd)this.objList[i.intValue()])._name + "\" of (sys:" + ((Thd)this.objList[i.intValue()])._threadId + ") (TID:" + this._reversedTid.get(((Thd)this.objList[i.intValue()])._threadId) + ")\n" + "\tHolding Resource: " + ((Monitor)this.adjMat[i.intValue()][value.intValue()])._name + "\n\tThread Waiting: \"" + ((Thd)this.objList[value.intValue()])._name + "\" (sys:" + ((Thd)this.objList[value.intValue()])._threadId + ") (TID:" + this._reversedTid.get(((Thd)this.objList[value.intValue()])._threadId) + ")\n");
                }
            }
            result = new Vector<String>(deadlockResults.size() + ((Vector)tempResult.get(0)).size());
            result.add("\n\nDeadlock Detection Report\n------------------------\n");
            if (deadlockResults.size() > 0 || ((Vector)tempResult.get(0)).size() > 1) {
                this.deadlockExists = true;
            } else {
                result.add("No deadlock(s) found.\n");
            }
            if (deadlockResults.size() > 1) {
                result.add("The following threads appear to be in a circular deadlock.\nFurther information can be found by looking in the Overall Thread Analysis\nsection of this tool.\n");
            }
            result.addAll(deadlockResults);
            if (((Vector)tempResult.get(0)).size() > 1) {
                result.addAll((Vector)tempResult.get(0));
            }
            result.add("------------------------");
            return result;
        }
        return null;
    }

    public boolean getDeadlockExists() {
        return this.deadlockExists;
    }

    public void putReversedTid(Hashtable _rTid) {
        this._reversedTid = _rTid;
    }
}

