/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpParserLinux131_Suse_cxppc
extends DumpParser {
    public void parse(DumpData d) throws Exception {
        DumpParserLinux131_Suse_cxppc.logDebug("parse thread dump compatible with IBM Linux/Suse cxppc build");
        try {
            if (this._r.ready()) {
                String s = this._r.readLine();
                this.getThreadData(d);
                this.resetFileReader();
                this.getMonitorPoolStats(d);
                this.getMonitors(d);
                this.getHeapLockWaiters(d);
                while (this.getLine(d) != null) {
                }
            }
        }
        catch (Exception e) {
            ++this._lineNo;
            DumpParserLinux131_Suse_cxppc.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + this._lineNo + " -- " + _dumpInName);
            throw new TaException("" + this._lineNo, e);
        }
    }

    private void getHeapLockWaiters(DumpData d) throws Exception {
        String line = this.getLine(d);
        if (line == null) {
            return;
        }
        while (line.indexOf("Heap lock") < 0) {
            DumpParserLinux131_Suse_cxppc.logDebug(line);
            line = this.getLine(d);
        }
        line = this.getLine(d);
        if (line.indexOf("Waiting to enter:") >= 0 || line.indexOf("Waiting to be notified") >= 0) {
            Monitor m = d.addMonitor("HEAP_LOCK", 1);
            line = this.getLine(d);
            DumpParserLinux131_Suse_cxppc.logDebug(TAUtils.getNLSValue("ta.msg.HeapLockWaiters", "Heap lock waiters") + ": ");
            while (line.charAt(0) == '\t') {
                DumpParserLinux131_Suse_cxppc.logDebug(" -- " + line);
                String thdId = null;
                int idx1 = line.indexOf(40);
                thdId = line.substring(idx1 + 1, line.indexOf(41));
                Thd t = d.getThd(thdId);
                m.addWaiter(t);
                DumpParserLinux131_Suse_cxppc.logDebug("  *" + thdId + "*");
                line = this.getLine(d);
            }
        }
    }

    private void getMonitorPoolStats(DumpData d) throws Exception {
        String line = null;
        line = this.getLine(d);
        while (line != null && line.indexOf("Monitor Pool Dump") == -1) {
            line = this.getLine(d);
        }
    }

    private void getMonitors(DumpData d) throws Exception {
        boolean done = false;
        String line = null;
        line = this.getLine(d);
        if (line == null) {
            return;
        }
        while (!done) {
            line = this.getLine(d);
            if (line == null || line.indexOf("NULL") != -1) continue;
            if (line.indexOf("JVM System Monitor Dump") != -1) {
                done = true;
                continue;
            }
            int idx1 = line.indexOf(58);
            String monitor = line.substring(0, idx1);
            monitor.trim();
            Monitor m = d.addMonitor(monitor, 1);
            DumpParserLinux131_Suse_cxppc.logDebug(" -" + TAUtils.getNLSValue("ta.string.monitor", "monitor") + " " + monitor);
            line = this.getLine(d);
            if (line.indexOf("Waiting to be notified") != -1 || line.indexOf("Waiting to enter:") != -1) {
                line = this.getLine(d);
            }
            while (line.trim().length() > 0 && line.trim().charAt(0) == '\"') {
                if (line.length() <= 0 || line.charAt(0) != '\t') continue;
                DumpParserLinux131_Suse_cxppc.logDebug(" -- " + TAUtils.getNLSValue("ta.string.waiter", "waiter") + " " + line);
                String thdId = null;
                idx1 = line.lastIndexOf(40);
                thdId = line.substring(idx1 + 1, line.lastIndexOf(41));
                DumpParserLinux131_Suse_cxppc.logDebug("\ttid=" + thdId);
                Thd t = d.getThd(thdId);
                m.addWaiter(t);
                line = this.getLine(d);
            }
            if (!line.trim().equals("") && line.indexOf("JVM System Monitor Dump") == -1) continue;
            done = true;
        }
    }

    private void getThreadData(DumpData d) throws Exception {
        String line = null;
        boolean firstChar = false;
        line = this.getLine(d);
        Thd thd = null;
        while (line.indexOf("Full thread dump") == -1) {
            line = this.getLine(d);
        }
        while (line.indexOf("\"") == -1) {
            line = this.getLine(d);
        }
        while (line != null && line.indexOf("CL subcomponent") == -1) {
            while (line != null && line.indexOf("sys_thread_t") == -1 && line.indexOf("CL subcomponent") == -1) {
                line = this.getLine(d);
            }
            if (line != null && line.indexOf("CL subcomponent") != -1) break;
            while (line != null && line.length() > 0 && line.indexOf("Native Stack of") == -1) {
                if (line.indexOf("sys_thread_t") != -1) {
                    int idx1 = line.indexOf(34);
                    int idx2 = line.indexOf(34, idx1 + 1);
                    String thdNm = line.substring(idx1 + 1, idx2);
                    idx1 = line.indexOf("sys_thread_t:");
                    String line2 = line.substring(idx1);
                    idx2 = line2.indexOf(44);
                    String threadId = line2.substring(13, idx2);
                    idx1 = line.indexOf("state:") + 6;
                    idx2 = line.indexOf(44, idx1);
                    String state = line.substring(idx1, idx2);
                    idx1 = line.indexOf("prio=");
                    String priority = line.substring(idx1 + 5);
                    DumpParserLinux131_Suse_cxppc.logDebug(thdNm + " - " + threadId + " - " + state + " - " + priority);
                    thd = d.addThd(thdNm, threadId, state, priority);
                } else if (line.indexOf(" at ") != -1 && line.indexOf("...") == -1 && line.indexOf(", sp =") == -1 && line.indexOf("javacore") == -1) {
                    String line2 = line.substring(line.indexOf(" at ") + 4);
                    boolean isNative = false;
                    String moduleName = null;
                    String lineno = null;
                    int idx1 = line2.indexOf("(Native Method)");
                    if (idx1 > 0) {
                        isNative = true;
                        line2 = line2.substring(0, idx1);
                    } else {
                        idx1 = line2.indexOf("(");
                        String moduleInfo = line2.substring(++idx1);
                        DumpParserLinux131_Suse_cxppc.logDebug("Parsing moduleInfo: " + moduleInfo);
                        line2 = line2.substring(0, idx1 - 1);
                        int idx2 = moduleInfo.indexOf(58);
                        if (idx2 > 0) {
                            lineno = moduleInfo.substring(idx2 + 1, moduleInfo.indexOf(41, idx2) - 1);
                            moduleName = moduleInfo.substring(0, idx2);
                            DumpParserLinux131_Suse_cxppc.logDebug("Found moduleName: " + moduleName + "  lineno: " + lineno);
                        } else {
                            idx2 = moduleInfo.indexOf(40);
                            if (idx2 == -1) {
                                idx2 = moduleInfo.indexOf(41);
                            }
                            moduleName = moduleInfo.substring(0, idx2);
                            DumpParserLinux131_Suse_cxppc.logDebug("Found moduleName: " + moduleName + "  and no line number...");
                        }
                    }
                    String method = line2.substring(line2.lastIndexOf(46) + 1);
                    String pkg = line2.substring(0, line2.lastIndexOf(46));
                    int iLineNo = -1;
                    if (lineno != null) {
                        iLineNo = Integer.parseInt(lineno);
                    }
                    StkEntry se = new StkEntry(method, pkg, moduleName, iLineNo, isNative);
                    DumpParserLinux131_Suse_cxppc.logDebug("  -- " + pkg + " . " + method + " - " + " - " + moduleName + " - " + lineno + " - " + isNative);
                    thd.addStackEntry(se);
                }
                line = this.getLine(d);
            }
            line = this.getLine(d);
            if (line == null) continue;
            while (line.indexOf("----") == -1) {
                StkEntryNative sen = new StkEntryNative(null, line.trim());
                DumpParserLinux131_Suse_cxppc.logDebug("  -- " + line);
                thd.addStackEntryNative(sen);
                line = this.getLine(d);
            }
        }
    }
}

