/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.jvm.threadanalysis;

import java.io.File;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpAgent;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpGeneratorImpl;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpProcessorImpl;

public class ThreadDumpAgentImpl
implements ThreadDumpAgent {
    private static boolean debug = false;
    private static final String dllname = "hcthread";
    private String name = "Thread Analyzer Agent";
    private String type = "Logging";

    public static void main(String[] args) {
        ThreadDumpAgentImpl tdAgent = new ThreadDumpAgentImpl();
        tdAgent.init();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                tdAgent.dump();
                tdAgent.deregister();
                continue;
            }
            break;
        }
    }

    public void init() {
        String myname = this.name + ":" + this.hashCode();
        this.init0(myname, this.type);
        ThreadDumpAgentImpl.debugTrace("Initialized agent: " + myname);
    }

    public void dump() {
        this.dumpThreads0();
        ThreadDumpAgentImpl.debugTrace("Dump completed");
    }

    public void deregister() {
        this.deregister0();
        ThreadDumpAgentImpl.debugTrace("Deregisterd agent");
    }

    private static File findJavaCore(String path, int pid) {
        File result = null;
        long newestTime = 0L;
        File dir = new File(path);
        if (dir != null) {
            ThreadDumpAgentImpl.debugTrace("Checking directory: " + path);
            File[] dirList = dir.listFiles();
            if (dirList != null) {
                for (int i = 0; i < dirList.length; ++i) {
                    String fileName = dirList[i].getName();
                    ThreadDumpAgentImpl.debugTrace("Checking file: " + fileName);
                    if (!ThreadDumpAgentImpl.isJavaCore(fileName, pid) || dirList[i].lastModified() <= newestTime) continue;
                    ThreadDumpAgentImpl.debugTrace("Modified time: " + dirList[i].lastModified());
                    ThreadDumpAgentImpl.debugTrace("Base time: " + newestTime);
                    result = dirList[i];
                    newestTime = dirList[i].lastModified();
                }
            }
        }
        return result;
    }

    private static boolean isJavaCore(String name, int pid) {
        if (name.startsWith("javacore" + pid) && name.endsWith(".txt") || name.startsWith("Javadump") && name.endsWith(".txt") || name.equals("javacore.txt") || name.startsWith("javacore") && name.endsWith(pid + ".txt")) {
            return true;
        }
        return System.getProperty("os.name").equals("Linux") && name.startsWith("javacore") && name.endsWith(".txt");
    }

    private static String processDumpData(String path) {
        String cbeString = "";
        ThreadDumpGeneratorImpl thdGenerator = new ThreadDumpGeneratorImpl();
        ThreadDumpProcessorImpl thdProcessor = new ThreadDumpProcessorImpl();
        File fJavaCore = ThreadDumpAgentImpl.findJavaCore(path, ThreadDumpAgentImpl.getPid0());
        if (fJavaCore != null) {
            String sJavaCore = fJavaCore.getAbsolutePath().replace('\\', '/');
            ThreadDumpAgentImpl.debugTrace("Javacore found: " + sJavaCore);
            DumpData dd = thdGenerator.dump(sJavaCore);
            ThreadDumpAgentImpl.debugTrace("DumpData obtained");
            if (dd != null) {
                Vector cbes = thdProcessor.generateCBEs(dd);
                if (cbes != null) {
                    ThreadDumpAgentImpl.debugTrace("CBE generated");
                    for (int j = 0; j < cbes.size(); ++j) {
                        cbeString = cbeString + CbeFormatter.toCanonicalXMLString((ICommonBaseEvent)((ICommonBaseEvent)cbes.elementAt(j)));
                    }
                    return cbeString;
                }
                return new String("<CommonBaseEvent msg=\"No common base event\"/>");
            }
            return new String("<CommonBaseEvent msg=\"No dump data\"/>");
        }
        return new String("<CommonBaseEvent msg=\"No java core file\"/>");
    }

    private static void debugTrace(String msg) {
        if (debug) {
            System.out.println("DEBUG(JAVA): " + msg);
        }
    }

    private native void dumpThreads0();

    private native void init0(String var1, String var2);

    private native void deregister0();

    private static native int getPid0();

    static {
        if (System.getProperty("debug") != null) {
            debug = true;
            ThreadDumpAgentImpl.debugTrace("Debug is ON");
        }
        System.loadLibrary(dllname);
        ThreadDumpAgentImpl.debugTrace("Finished loading native library: hcthread");
    }
}

