/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDMeasuredVariable;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDMeasuredVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariable;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.swt.graphics.Image;

public class SDVariableLoader {
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    SDDescriptor root;
    SDSampleWindow window;

    public SDVariableLoader(SDDescriptor model_root) {
        this.root = model_root;
        this.window = this.getOrCreateView(this.root.getAgent());
    }

    public SDVariableLoader(TRCAgent agent, String root_name) {
        this.root = this.factory.createSDDescriptor();
        this.root.setName(root_name);
        this.root.setAgent(agent);
        this.window = this.getOrCreateView(this.root.getAgent());
    }

    public SDDescriptor getModelRoot() {
        return this.root;
    }

    private SDSampleWindow getOrCreateView(TRCAgent trcagent) {
        SDView view = (SDView)trcagent.getView();
        if (view == null) {
            view = this.factory.createSDView();
            view.setAgent(trcagent);
            view.setName("view");
        }
        if (view.eContents().size() == 0) {
            SDSampleWindow window = this.factory.createSDSampleWindow();
            window.setView(view);
            return window;
        }
        return (SDSampleWindow)view.eContents().get(0);
    }

    public SDMeasuredVariableRepresentation createSDMeasuredVariable(String unique_varid, String varname, String vardesc, Image image, boolean has_bar, int vartype, String ownerid, String ownerparent) {
        SDMemberDescriptor vardescriptor = (SDMemberDescriptor)this.getDescriptor(ownerid, ownerparent);
        if (vardescriptor == null) {
            vardescriptor = this.createMemberDescriptor(ownerid, ownerparent);
        }
        SDMeasuredVariable variable = new SDMeasuredVariable(unique_varid, varname, vardesc, image, has_bar, vartype, vardescriptor, this.window);
        return variable;
    }

    public SDModifiableVariableRepresentation createSDModifiableVariable(String unique_varid, String varname, String vardesc, Image image, boolean has_bar, int measured_vartype, int modifier_vartype, String ownerid, String ownerparent, SDVariableModifierProxy modifier, double minbound, double maxbound) {
        SDMemberDescriptor vardescriptor = (SDMemberDescriptor)this.getDescriptor(ownerid, ownerparent);
        if (vardescriptor == null) {
            vardescriptor = this.createMemberDescriptor(ownerid, ownerparent);
        }
        SDModifiableVariable variable = new SDModifiableVariable(unique_varid, varname, vardesc, image, has_bar, measured_vartype, modifier_vartype, vardescriptor, modifier, minbound, maxbound, this.window);
        return variable;
    }

    private SDDescriptor getDescriptor(String id, String parentid) {
        return this.getDescriptor(this.root, id, parentid, this.root.getName().equals(parentid));
    }

    private SDDescriptor getDescriptor(SDDescriptor descriptor, String id, String parentid, boolean descriptor_is_parent) {
        EList children = descriptor.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SDDescriptor child = (SDDescriptor)children.get(i);
            String childname = child.getName();
            if (descriptor_is_parent && child.getName().equals(id)) {
                return child;
            }
            if ((child = this.getDescriptor(child, id, parentid, child.getName().equals(parentid))) == null) continue;
            return child;
        }
        return null;
    }

    private SDMemberDescriptor createMemberDescriptor(String id, String parentid) {
        SDMemberDescriptor desc = this.createMemberDescriptor(this.root, id, parentid);
        if (desc == null) {
            SDCounterDescriptor parent = this.factory.createSDCounterDescriptor();
            parent.setParent(this.root);
            parent.setName(parentid);
            SDCounterDescriptor child = this.factory.createSDCounterDescriptor();
            child.setParent((SDDescriptor)parent);
            child.setName(id);
            return child;
        }
        return desc;
    }

    private SDMemberDescriptor createMemberDescriptor(SDDescriptor descriptor, String id, String parentid) {
        if (descriptor.getName().equals(parentid)) {
            SDCounterDescriptor child = this.factory.createSDCounterDescriptor();
            child.setParent(descriptor);
            child.setName(id);
            return child;
        }
        EList children = descriptor.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SDDescriptor child = (SDDescriptor)children.get(i);
            SDMemberDescriptor mchild = this.createMemberDescriptor(child, id, parentid);
            if (mchild == null) continue;
            return mchild;
        }
        return null;
    }
}

