/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LogAsyncMessage
extends AsyncMessage
implements IPropertySource {
    private List correlationList = null;
    private LogGraphNode sourceNode = null;
    private LogGraphNode targetNode = null;
    private int type;
    private IPropertyDescriptor[] propertyDescriptors;
    private static final String PROPERTY_LIST = "correlation.list.";

    public LogAsyncMessage(int type) {
        this.type = type;
    }

    public void setSourceNode(LogGraphNode sourceNode) {
        this.sourceNode = sourceNode;
    }

    public void setTargetNode(LogGraphNode targetNode) {
        this.targetNode = targetNode;
    }

    public void addPair(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        SourceTargetPair pair = new SourceTargetPair(source, target);
        this.correlationList.add(pair);
    }

    public List getPairs() {
        return this.correlationList;
    }

    public void generatePairs() {
        if (this.correlationList != null) {
            return;
        }
        this.correlationList = new ArrayList();
        List<Object> sourceElements = null;
        if (this.sourceNode.hasElements() && !this.sourceNode.isExpanded()) {
            sourceElements = this.sourceNode.getElements();
        } else {
            sourceElements = new ArrayList<EObject>(1);
            sourceElements.add(this.sourceNode.getElement());
        }
        List<Object> targetElements = null;
        if (this.targetNode.hasElements() && !this.targetNode.isExpanded()) {
            targetElements = this.targetNode.getElements();
        } else {
            targetElements = new ArrayList<EObject>(1);
            targetElements.add(this.targetNode.getElement());
        }
        if (this.type == 0) {
            this.generateCorrelationListXMI(sourceElements, targetElements);
        } else if (this.type == 1) {
            this.generateCorrelationListSQL(sourceElements, targetElements);
        }
    }

    private void generateCorrelationListSQL(List sourceElements, List targetElements) {
        LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
        QueryResult correlations = loader.getCorrelations();
        ResultEntry resultEntry = (ResultEntry)correlations.getResultEntries().get(0);
        EList keysList = resultEntry.getObjects();
        resultEntry = (ResultEntry)correlations.getResultEntries().get(1);
        EList valuesList = resultEntry.getObjects();
        if (keysList.size() > 0) {
            CBECommonBaseEvent source = (CBECommonBaseEvent)sourceElements.get(0);
            CBECommonBaseEvent target = null;
            int startIndex = keysList.indexOf(source);
            source = (CBECommonBaseEvent)keysList.get(sourceElements.size() - 1);
            int s = keysList.size();
            for (int i = startIndex; i < s; ++i) {
                source = (CBECommonBaseEvent)keysList.get(i);
                target = (CBECommonBaseEvent)valuesList.get(i);
                if (!sourceElements.contains(source)) break;
                if (!targetElements.contains(target)) continue;
                this.addPair(source, target);
            }
        }
    }

    private void generateCorrelationListXMI(List sourceElements, List targetElements) {
        CBECommonBaseEvent source = null;
        List targetList = null;
        CorrelationEntryImpl entry = null;
        Object key = null;
        LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
        EMap correlations = loader.getCorrelationContainerProxy().getCorrelationContainer().getCorrelations();
        Iterator iter = correlations.iterator();
        while (iter.hasNext()) {
            entry = (CorrelationEntryImpl)iter.next();
            key = entry.getKey();
            if (!(key instanceof CBECommonBaseEvent) || !sourceElements.contains(source = (CBECommonBaseEvent)key) || (targetList = (List)entry.getValue()) == null) continue;
            int s = targetList.size();
            for (int i = 0; i < s; ++i) {
                CBECommonBaseEvent target = (CBECommonBaseEvent)targetList.get(i);
                if (!targetElements.contains(target)) continue;
                this.addPair(source, target);
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.generatePairs();
        if (this.correlationList.size() == 1) {
            if (this.propertyDescriptors == null) {
                this.propertyDescriptors = new IPropertyDescriptor[1];
                PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor((Object)PROPERTY_LIST, "[" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)this.correlationList.get(0)).getSourceEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)this.correlationList.get(0)).getSourceEvent().getMsg());
                cbeListsDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return "--> [" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)LogAsyncMessage.this.correlationList.get(0)).getTargetEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)LogAsyncMessage.this.correlationList.get(0)).getTargetEvent().getMsg();
                    }
                });
                cbeListsDescriptor.setCategory(TString.change((String)SDLogcPlugin.getString("STR_LOG_CORR"), (String)"%1", (String)("" + this.correlationList.size())));
                this.propertyDescriptors[0] = cbeListsDescriptor;
            }
        } else if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new IPropertyDescriptor[this.correlationList.size()];
            for (int i = 0; i < this.correlationList.size(); ++i) {
                PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor((Object)(PROPERTY_LIST + i), "[" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)this.correlationList.get(i)).getSourceEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)this.correlationList.get(i)).getSourceEvent().getMsg());
                final int idx = i;
                cbeListsDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return "--> [" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)LogAsyncMessage.this.correlationList.get(idx)).getTargetEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)LogAsyncMessage.this.correlationList.get(idx)).getTargetEvent().getMsg();
                    }
                });
                cbeListsDescriptor.setCategory(TString.change((String)SDLogcPlugin.getString("STR_LOG_CORRS"), (String)"%1", (String)("" + this.correlationList.size())));
                this.propertyDescriptors[i] = cbeListsDescriptor;
            }
        }
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if (((String)id).indexOf(PROPERTY_LIST) == 0) {
            return this.correlationList;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public LogGraphNode getSourceNode() {
        return this.sourceNode;
    }

    public LogGraphNode getTargetNode() {
        return this.targetNode;
    }

    public class SourceTargetPair {
        private CBECommonBaseEvent sourceEvent;
        private CBECommonBaseEvent targetEvent;

        public SourceTargetPair(CBECommonBaseEvent source, CBECommonBaseEvent target) {
            this.setSourceEvent(source);
            this.setTargetEvent(target);
        }

        public CBECommonBaseEvent getSourceEvent() {
            return this.sourceEvent;
        }

        public void setSourceEvent(CBECommonBaseEvent sourceEvent) {
            this.sourceEvent = sourceEvent;
        }

        public CBECommonBaseEvent getTargetEvent() {
            return this.targetEvent;
        }

        public void setTargetEvent(CBECommonBaseEvent targetEvent) {
            this.targetEvent = targetEvent;
        }
    }
}

