/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBVisitor;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.QueryFactory;
import org.eclipse.hyades.resources.database.internal.ReferenceQuery;
import org.eclipse.hyades.resources.database.internal.impl.DynamicPagingListImpl;

public class DBVisitorImpl
implements DBVisitor {
    protected Database database;
    protected int pagingSize;

    public DBVisitorImpl(Database database, int pagingSize) {
        this.database = database;
        this.pagingSize = pagingSize;
    }

    public Object get(EObject object, EReference reference) {
        if (reference.isMany()) {
            DynamicPagingListImpl list = new DynamicPagingListImpl((InternalEObject)object, (EStructuralFeature)reference, this.database, this.pagingSize);
            list.setReferences(false);
            return list;
        }
        return this.getSingleObject(object, reference);
    }

    protected Object getSingleObject(EObject object, EReference reference) {
        ReferenceQuery query = QueryFactory.INSTANCE.createReferenceQuery();
        query.setEObject(object);
        query.setEReference(reference);
        query.setReferences(false);
        EObject[] objects = null;
        try {
            objects = this.database.getObjects(query);
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
        if (objects == null) {
            return null;
        }
        return objects[0];
    }

    public void setPagingSize(int size) {
        this.pagingSize = size;
    }

    public int getPagingSize() {
        return this.pagingSize;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }
}

