/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class SimpleSearchQueryStatement
extends QueryStatement {
    protected JDBCHelper helper;
    protected SimpleSearchQuery query;
    protected Set processedAlready = new HashSet();
    protected boolean first = true;
    protected boolean all = false;
    protected Set fromSet = new HashSet();

    public SimpleSearchQueryStatement(JDBCHelper helper, DBMap dbMap, SimpleSearchQuery query) {
        super(helper.getDatabaseType(), dbMap, null);
        this.helper = helper;
        this.query = query;
    }

    protected void createOrderClause() {
        this.first = true;
        this.processedAlready.clear();
        this.processOrderByExpressionsInOrderByClause();
        this.processedAlready.clear();
    }

    protected void processOrderByExpressionsInOrderByClause() {
        Iterator iter = this.query.getOrderByExpresions().iterator();
        while (iter.hasNext()) {
            OrderByElement oe = (OrderByElement)iter.next();
            if (oe.getOperand() == null || oe.getOperand().getFeature() == null || oe.getOperator() == null || this.processedAlready.contains(oe.getOperand().getFeature())) continue;
            this.processedAlready.add(oe.getOperand().getFeature());
            if (this.first) {
                this.statement.append(" ORDER BY ");
                this.first = false;
            } else {
                this.statement.append(", ");
            }
            DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)oe.getOperand().getFeature());
            this.statement.append(this.addQuotes(data.getValueColumn().getName()));
            this.statement.append(" ");
            this.statement.append(oe.getOperator().getName());
        }
    }

    protected void createSelectFrom() {
        this.first = true;
        this.all = false;
        this.fromSet.clear();
        this.processedAlready.clear();
        this.processOutputElementsInSelectFrom();
        this.processOrderByInSelectFrom();
        this.processWhereClauseInSelectFrom();
        this.processedAlready.clear();
        this.first = true;
        this.processFromSet();
        this.processedAlready.clear();
    }

    protected void processWhereClauseInSelectFrom() {
        Iterator iter = this.query.getWhereExpressions().iterator();
        while (iter.hasNext()) {
            Object data;
            SimpleBinaryExpression sbe = (SimpleBinaryExpression)iter.next();
            LeftOperand oe = sbe.getOperand();
            String tableName = null;
            if (oe.getFeature() != null) {
                data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)oe.getFeature());
                tableName = ((DBMap.AttributeData)data).getValueColumn().getTable().getName();
            } else if (oe.getType() != null) {
                data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)oe.getType());
                tableName = ((DBMap.ClassData)data).getTable().getName();
            }
            if (tableName != null) {
                this.fromSet.add(tableName);
            }
            tableName = null;
            if (sbe.getRightOperand() instanceof EModelElement) {
                Object data2;
                EModelElement element = (EModelElement)sbe.getRightOperand();
                if (element instanceof EStructuralFeature) {
                    if (element instanceof EAttribute) {
                        data2 = (DBMap.AttributeData)this.dbMap.getDBRepresentation(element);
                        tableName = ((DBMap.AttributeData)data2).getValueColumn().getTable().getName();
                    } else {
                        data2 = (DBMap.ReferenceData)this.dbMap.getDBRepresentation(element);
                        tableName = ((DBMap.ReferenceData)data2).getTargetColumn().getTable().getName();
                    }
                } else if (element instanceof EClass) {
                    data2 = (DBMap.ClassData)this.dbMap.getDBRepresentation(element);
                    tableName = ((DBMap.ClassData)data2).getTable().getName();
                }
            }
            if (tableName == null) continue;
            this.fromSet.add(tableName);
        }
    }

    protected void processFromSet() {
        Iterator iter = this.fromSet.iterator();
        while (iter.hasNext()) {
            String tableName = (String)iter.next();
            if (this.processedAlready.contains(tableName)) continue;
            if (this.first) {
                this.statement.append(" FROM ");
                this.first = false;
            } else {
                this.statement.append(", ");
            }
            this.statement.append(this.addQuotes(tableName));
        }
    }

    protected void processOutputElementsInSelectFrom() {
        Iterator iter = this.query.getOutputElements().iterator();
        while (iter.hasNext()) {
            LeftOperand oe = (LeftOperand)iter.next();
            if (this.processedAlready.contains(this.getOperandType(oe))) continue;
            if (this.first) {
                this.statement.append("SELECT ");
                if (this.query.isDistinct()) {
                    this.statement.append("DISTINCT ");
                }
                this.first = false;
            } else {
                this.statement.append(", ");
            }
            this.fromSet.add(this.addOperandName(oe));
        }
        if (this.first && this.query.isCount()) {
            this.statement.append("SELECT ");
            this.statement.append("COUNT(*) ");
            this.all = true;
            this.first = false;
        } else if (this.first) {
            this.statement.append("SELECT ");
            if (this.query.isDistinct()) {
                this.statement.append("DISTINCT ");
            }
            this.statement.append("* ");
            this.all = true;
            this.first = false;
        }
    }

    protected void processOrderByInSelectFrom() {
        if (!this.all && this.query.isDistinct()) {
            Iterator iter = this.query.getOrderByExpresions().iterator();
            while (iter.hasNext()) {
                OrderByElement oe = (OrderByElement)iter.next();
                if (this.processedAlready.contains(this.getOperandType(oe.getOperand()))) continue;
                if (this.first) {
                    this.statement.append("SELECT ");
                    if (this.query.isDistinct()) {
                        this.statement.append("DISTINCT ");
                    }
                    this.first = false;
                } else {
                    this.statement.append(", ");
                }
                this.fromSet.add(this.addOperandName(oe.getOperand()));
            }
        }
    }

    protected String addOperandName(LeftOperand oe) {
        String tableName = "";
        String columnName = "";
        if (oe.getFeature() != null) {
            this.processedAlready.add(oe.getFeature());
            DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)oe.getFeature());
            tableName = data.getValueColumn().getTable().getName();
            columnName = data.getValueColumn().getName();
        } else if (oe.getType() != null) {
            this.processedAlready.add(oe.getType());
            DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)oe.getType());
            tableName = data.getTable().getName();
            columnName = this.dbMap.getClassMetadata(oe.getType()).getPrimaryKey().getName();
        }
        if (oe.isCount() || this.query.isCount()) {
            this.statement.append("COUNT(");
        }
        this.statement.append(this.addQuotes(tableName));
        this.statement.append('.');
        this.statement.append(this.addQuotes(columnName));
        if (oe.isCount() || this.query.isCount()) {
            this.statement.append(")");
        }
        return tableName;
    }

    protected EObject getOperandType(LeftOperand oe) {
        if (oe.getFeature() != null) {
            return oe.getFeature();
        }
        if (oe.getType() != null) {
            return oe.getType();
        }
        return null;
    }

    protected void createWhereClause(int begin) {
        this.first = true;
        this.processedAlready.clear();
        this.processBinaryExpressions();
        this.appendWhereClauseForSources();
        this.processedAlready.clear();
    }

    protected void processBinaryExpressions() {
        Iterator iter = this.query.getWhereExpressions().iterator();
        while (iter.hasNext()) {
            SimpleBinaryExpression sbe = (SimpleBinaryExpression)iter.next();
            if (this.processedAlready.contains(sbe)) continue;
            if (this.first) {
                this.statement.append(" WHERE ");
                this.first = false;
            } else {
                this.statement.append(" AND ");
            }
            this.addOperandName(sbe.getOperand());
            this.statement.append(" ");
            this.statement.append(RelationalOperators.getString((int)sbe.getOperator().getValue()));
            this.statement.append(" ");
            if (sbe.getRightOperand() instanceof EModelElement) {
                this.addRightOperand((EModelElement)sbe.getRightOperand());
                continue;
            }
            if (sbe.getRightOperand() instanceof String) {
                this.statement.append("'");
                this.statement.append(sbe.getRightOperand().toString());
                this.statement.append("'");
                continue;
            }
            if (sbe.getRightOperand() instanceof Boolean) {
                this.statement.append("'");
                this.statement.append((Boolean)sbe.getRightOperand() != false ? (char)'1' : '0');
                this.statement.append("'");
                continue;
            }
            this.statement.append(sbe.getRightOperand().toString());
        }
    }

    protected void addRightOperand(EModelElement classifier) {
        String tableName = "";
        String columnName = "";
        if (classifier instanceof EStructuralFeature) {
            if (classifier instanceof EAttribute) {
                DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation(classifier);
                tableName = data.getValueColumn().getTable().getName();
                columnName = data.getValueColumn().getName();
            } else {
                DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation(classifier);
                tableName = data.getTargetColumn().getTable().getName();
                columnName = data.getTargetColumn().getName();
            }
        } else if (classifier instanceof EClass) {
            DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation(classifier);
            tableName = data.getTable().getName();
            columnName = this.dbMap.getClassMetadata((EClass)classifier).getPrimaryKey().getName();
        }
        if (tableName.length() > 0 && columnName.length() > 0) {
            this.statement.append(this.addQuotes(tableName));
            this.statement.append('.');
            this.statement.append(this.addQuotes(columnName));
        }
    }

    protected void appendWhereClauseForSources() {
        boolean firstSource = true;
        boolean andBracket = false;
        Iterator iter = this.query.getSources().iterator();
        while (iter.hasNext()) {
            String source = (String)iter.next();
            if (this.first) {
                this.statement.append(" WHERE (");
                this.first = false;
                firstSource = false;
            } else if (firstSource) {
                this.statement.append(" AND (");
                if (this.query.getSources().size() > 1) {
                    this.statement.append(" (");
                    andBracket = true;
                }
                firstSource = false;
            } else {
                this.statement.append(") OR (");
            }
            String containerPath = this.getObjectCompressedURIFragment(source);
            this.addContainedIn(containerPath, this.isRootObject(source));
        }
        if (this.query.getSources().size() > 0) {
            this.statement.append(") ");
        }
        if (andBracket) {
            this.statement.append(") ");
        }
    }

    protected boolean isRootObject(String source) {
        int i = source.indexOf(35);
        return i != -1 && source.indexOf(i + 1, 47) == -1;
    }

    protected void addContainedIn(String containerPath, boolean rootObject) {
        boolean first = true;
        Iterator iter = this.query.getOutputElements().iterator();
        while (iter.hasNext()) {
            LeftOperand output = (LeftOperand)iter.next();
            EClass eClass = null;
            eClass = output.getFeature() != null ? output.getFeature().getEContainingClass() : output.getType();
            String tableName = this.dbMap.getClassMetadata(eClass).getTable().getName();
            if (first) {
                first = false;
            } else {
                this.statement.append(" AND ");
            }
            this.statement.append(this.addQuotes(tableName));
            this.statement.append(".");
            if (rootObject && tableName.equals("TRCAgent")) {
                this.statement.append(this.addQuotes(this.dbMap.getClassMetadata(eClass).getPrimaryKey().getName()));
                this.statement.append(" = ");
                this.statement.append(containerPath.substring(0, containerPath.indexOf(47)));
                continue;
            }
            this.statement.append(this.addQuotes("p_p"));
            this.statement.append(" LIKE ");
            this.statement.append("'" + containerPath + "%'");
        }
    }

    protected String getObjectCompressedURIFragment(String source) {
        PerfUtil p = new PerfUtil("SimpleSearchQueryStatement.getObjectCompressedURIFragment()", true);
        DBCommand command = DBCommandFactory.INSTANCE.createGetCommpressedPathByURICommand(this.helper, this.dbMap, source);
        String s = "";
        try {
            s = (String)command.execute();
        }
        catch (Exception e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw new DBCollectedExceptions(e);
        }
        p.stopAndPrintStatus(s);
        return s;
    }
}

