/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.Serializable;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class EventFactoryImplTest
extends TestCase
implements Serializable {
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryObjectFactory;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryImpl;

    public EventFactoryImplTest(String string) {
        super(string);
    }

    public void testInterface() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        eventFactory.getEventPackage();
        Assert.assertNotNull((Object)eventFactory.createAssociatedEvent());
        Assert.assertNotNull((Object)eventFactory.createAssociationEngine());
        Assert.assertNotNull((Object)eventFactory.createAvailableSituation());
        Assert.assertNotNull((Object)eventFactory.createCommonBaseEvent());
        Assert.assertNotNull((Object)eventFactory.createComponentIdentification());
        Assert.assertNotNull((Object)eventFactory.createConfigureSituation());
        Assert.assertNotNull((Object)eventFactory.createConnectSituation());
        Assert.assertNotNull((Object)eventFactory.createContextDataElement());
        Assert.assertNotNull((Object)eventFactory.createCreateSituation());
        Assert.assertNotNull((Object)eventFactory.createDependencySituation());
        Assert.assertNotNull((Object)eventFactory.createDestroySituation());
        Assert.assertNotNull((Object)eventFactory.createExtendedDataElement());
        Assert.assertNotNull((Object)eventFactory.createFeatureSituation());
        String string = eventFactory.createGlobalInstanceId();
        Assert.assertTrue((String)("Guid must start with CE: " + string), (boolean)string.startsWith("CE"));
        Assert.assertNotNull((Object)eventFactory.createMsgCatalogToken());
        Assert.assertNotNull((Object)eventFactory.createMsgDataElement());
        Assert.assertNotNull((Object)eventFactory.createOtherSituation());
        Assert.assertNotNull((Object)eventFactory.createReportSituation());
        Assert.assertNotNull((Object)eventFactory.createRequestSituation());
        Assert.assertNotNull((Object)eventFactory.createSituation());
        Assert.assertNotNull((Object)eventFactory.createStartSituation());
        Assert.assertNotNull((Object)eventFactory.createStopSituation());
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent("A");
        Assert.assertEquals((String)"A", (String)commonBaseEvent.getExtensionName());
        commonBaseEvent = eventFactory.createCommonBaseEvent("A", 5L);
        Assert.assertEquals((String)"A", (String)commonBaseEvent.getExtensionName());
        Assert.assertEquals((long)5L, (long)commonBaseEvent.getCreationTimeAsLong());
    }

    public void testEPackage() {
        EventPackage eventPackage = EventFactoryImpl.getPackage();
        EList eList = eventPackage.eContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EClass eClass = (EClass)iterator.next();
            if (eClass.getName().equals("SituationType") || eClass.getName().equals("Serializable")) {
                try {
                    EventFactory.eINSTANCE.create(eClass);
                    Assert.fail((String)(eClass.getName() + " is not an instantiatable class"));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            EventFactory.eINSTANCE.create(eClass);
        }
    }

    public void testGetReference() {
        MockHandler mockHandler = new MockHandler("Example");
        EventFactoryImpl eventFactoryImpl = new EventFactoryImpl();
        eventFactoryImpl.setContentHandler(mockHandler);
        try {
            Reference reference = eventFactoryImpl.getReference();
            Assert.assertEquals((String)(class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryObjectFactory == null ? (class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryObjectFactory = EventFactoryImplTest.class$("org.eclipse.hyades.logging.events.cbe.impl.EventFactoryObjectFactory")) : class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryObjectFactory).getName(), (String)reference.getFactoryClassName());
            Assert.assertEquals((String)(class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryImpl == null ? (class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryImpl = EventFactoryImplTest.class$("org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl")) : class$org$eclipse$hyades$logging$events$cbe$impl$EventFactoryImpl).getName(), (String)reference.getClassName());
            Assert.assertNotNull((Object)reference.get(0));
        }
        catch (NamingException namingException) {
            Assert.fail((String)"The reference should be valid.");
        }
    }

    public void testJndiSupport() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        Assert.assertTrue((String)"EventFactoryImpl must extend java.io.Serializable", (boolean)(eventFactory instanceof Serializable));
        Assert.assertTrue((String)"EventFactoryImpl must extend javax.naming.Referenceable", (boolean)(eventFactory instanceof Referenceable));
    }

    public void testNonSerializableHandler() {
        ContentHandler contentHandler = new ContentHandler(){

            public void completeEvent(CommonBaseEvent commonBaseEvent) throws CompletionException {
                commonBaseEvent.setExtensionName("Example");
            }
        };
        EventFactoryImpl eventFactoryImpl = new EventFactoryImpl();
        eventFactoryImpl.setContentHandler(contentHandler);
        try {
            Reference reference = eventFactoryImpl.getReference();
            Assert.fail((String)"Cannot accept non-serializable mediation handler");
        }
        catch (NamingException namingException) {
            Util.assertExceptionId("IWAT0188E", namingException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MockHandler
    implements ContentHandler,
    Serializable {
        private String extensionName;

        public MockHandler(String string) {
            this.extensionName = string;
        }

        public void completeEvent(CommonBaseEvent commonBaseEvent) throws CompletionException {
            commonBaseEvent.setExtensionName(this.extensionName);
        }
    }
}

