/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageFolder;
import org.eclipse.hyades.trace.views.util.internal.CoverageLeaf;
import org.eclipse.hyades.trace.views.util.internal.CoverageUtil;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;

public class CoverageAnalysis {
    private CoverageFolder root = null;
    private HashMap coveragesMap = null;

    public CoverageAnalysis(EObject object) {
        Object[] packs = PerftraceUtil.getAllPackages(object);
        BasicEList listPack = new BasicEList();
        for (int i = 0; i < packs.length; ++i) {
            if (CoverageUtil.isFiltered((TRCPackage)packs[i])) continue;
            listPack.add(packs[i]);
        }
        this.root = !listPack.isEmpty() ? this.compute((EList)listPack, object) : null;
    }

    public CoverageLeaf FindCoverageLeaf(CoverageFolder parent, EObject obj) {
        TRCMethod m;
        String fullSig;
        CoverageLeaf cl;
        if (this.coveragesMap == null) {
            this.coveragesMap = new HashMap();
        }
        if ((cl = (CoverageLeaf)this.coveragesMap.get(fullSig = CoverageUtil.getFullSig(m = (TRCMethod)obj))) == null) {
            cl = new CoverageLeaf(this, parent);
            this.coveragesMap.put(fullSig, cl);
            parent.getChilds().add(cl);
        }
        cl.addTraceObjects(obj);
        return cl;
    }

    public CoverageFolder FindCoverageFolder(CoverageFolder parent, EObject obj) {
        if (this.coveragesMap == null) {
            this.coveragesMap = new HashMap();
        }
        String fullSig = null;
        if (obj instanceof TRCClass) {
            TRCClass c = (TRCClass)obj;
            fullSig = CoverageUtil.getFullSig(c);
        } else if (obj instanceof TRCPackage) {
            TRCPackage p = (TRCPackage)obj;
            fullSig = CoverageUtil.getFullSig(p);
        } else {
            fullSig = obj.toString();
        }
        CoverageFolder cf = (CoverageFolder)this.coveragesMap.get(fullSig);
        if (cf == null) {
            cf = new CoverageFolder(this, parent);
            this.coveragesMap.put(fullSig, cf);
            parent.getChilds().add(cf);
        }
        cf.addTraceObjects(obj);
        return cf;
    }

    protected CoverageFolder compute(EList listPack, EObject proc) {
        CoverageFolder cov = new CoverageFolder(this, null);
        cov.addTraceObjects(proc);
        cov.parse(listPack);
        cov.compute();
        return cov;
    }

    public Coverage getClassLevel() {
        CoverageFolder classLevel = this.duplicate(this.root);
        ArrayList classList = new ArrayList();
        classList.clear();
        ArrayList packList = this.root.getChilds();
        for (int i = 0; i < packList.size(); ++i) {
            Coverage covPack = (Coverage)packList.get(i);
            ArrayList list = covPack.getChilds();
            for (int j = 0; j < list.size(); ++j) {
                classList.add(list.get(j));
            }
        }
        classLevel.setChilds(classList);
        return classLevel;
    }

    public Coverage getMethodLevel() {
        int j;
        int i;
        ArrayList list = new ArrayList();
        ArrayList classList = new ArrayList();
        ArrayList methodList = new ArrayList();
        ArrayList methodListF = new ArrayList();
        CoverageFolder methodLevel = this.duplicate(this.root);
        ArrayList packList = this.root.getChilds();
        for (i = 0; i < packList.size(); ++i) {
            Coverage covPack = (Coverage)packList.get(i);
            list = covPack.getChilds();
            for (j = 0; j < list.size(); ++j) {
                classList.add(list.get(j));
            }
        }
        for (i = 0; i < classList.size(); ++i) {
            Coverage covClass = (Coverage)classList.get(i);
            list = covClass.getChilds();
            for (j = 0; j < list.size(); ++j) {
                methodList.add(list.get(j));
            }
        }
        for (i = 0; i < methodList.size(); ++i) {
            Coverage covElement = (Coverage)methodList.get(i);
            if (covElement.getTraceObj() instanceof TRCClass) {
                list = covElement.getChilds();
                for (j = 0; j < list.size(); ++j) {
                    methodListF.add(list.get(j));
                }
                continue;
            }
            methodListF.add(covElement);
        }
        methodLevel.setChilds(methodListF);
        return methodLevel;
    }

    protected CoverageFolder duplicate(CoverageFolder covArg) {
        CoverageFolder cov = new CoverageFolder(this, null, covArg);
        return cov;
    }

    public CoverageFolder getRoot() {
        return this.root;
    }
}

