/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.ProcessUnitTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProcessUnitSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Label uniqueId;
    protected Text descriptionText;
    protected boolean isDisplaying;
    protected ProcessUnitType currentSelection;
    protected ProcessUnitTypeItemProvider itemProvider;
    protected UnitItemProviderAdapterFactory itemFactory = new UnitItemProviderAdapterFactory();

    public ProcessUnitSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PU_DESCR"), 0);
        this.descriptionText = factory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PU_ID"), 0);
        this.uniqueId = factory.createLabel(this, "", 0);
        this.uniqueId.setLayoutData((Object)new GridData(768));
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.itemProvider = (ProcessUnitTypeItemProvider)this.itemFactory.createProcessUnitTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject object) {
        if (object != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)((ProcessUnitType)object).eContainer());
        }
        if (this.currentSelection == object) {
            return;
        }
        if (this.uniqueId.isFocusControl() || this.descriptionText.isFocusControl()) {
            return;
        }
        this.currentSelection = (ProcessUnitType)object;
        this.isDisplaying = true;
        this.uniqueId.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (ProcessUnitType)currentSelection;
        this.currentSelection.setUniqueID(this.uniqueId.getText());
        this.currentSelection.setDescription(this.descriptionText.getText());
        return false;
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.descriptionText && !(text = this.descriptionText.getText()).equals(this.currentSelection.getDescription())) {
            if (text.length() == 0 && this.currentSelection.getDescription() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ProcessUnitTypeItemProvider.DESCRIPTION);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }
}

