/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddTestSuiteChildAction;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddTestCaseAction
extends AddTestSuiteChildAction {
    private static Map testCaseTypesByTestSuiteType;

    public AddTestCaseAction() {
        super(TestUIPlugin.getString("BTN_ADD"));
        this.setToolTipText(TestUIPlugin.getString("ACT_TST_CASE_ADD_TIP"));
        this.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("testcase_obj.gif"));
        WorkbenchHelp.setHelp((IAction)this, (String)(TestUIPlugin.getID() + ".atca0001"));
    }

    protected boolean updateSelection(IStructuredSelection structuredSelection) {
        this.setActionPerformed(false);
        TPFTestSuite testSuite = this.getTestSuite(structuredSelection);
        if (testSuite == null) {
            return false;
        }
        String testSuiteType = testSuite.getType();
        if (testSuiteType == null) {
            return false;
        }
        HashSet<String> testCaseTypes = null;
        if (testCaseTypesByTestSuiteType == null) {
            testCaseTypesByTestSuiteType = new HashMap();
        } else {
            testCaseTypes = (HashSet<String>)testCaseTypesByTestSuiteType.get(testSuiteType);
        }
        if (testCaseTypes == null) {
            testCaseTypes = new HashSet<String>();
            testCaseTypesByTestSuiteType.put(testSuiteType, testCaseTypes);
            IAssociationMapping testSuiteTypeValidatorMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators");
            IAssociationDescriptor[] typeValidatorDescriptors = testSuiteTypeValidatorMapping.getAssociationDescriptors(testSuiteType);
            if (typeValidatorDescriptors.length == 0) {
                return false;
            }
            IAssociationMapping testCaseWizardMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
            String[] mappingTypes = testCaseWizardMapping.getTypes();
            int maxi = mappingTypes.length;
            block0: for (int i = 0; i < maxi; ++i) {
                int maxj = typeValidatorDescriptors.length;
                for (int j = 0; j < maxj; ++j) {
                    ITypeValidator typeValidator = (ITypeValidator)typeValidatorDescriptors[j].createImplementationClassInstance();
                    if (!typeValidator.isValidType(mappingTypes[i])) continue;
                    testCaseTypes.add(mappingTypes[i]);
                    continue block0;
                }
            }
        }
        return !testCaseTypes.isEmpty();
    }

    public void run() {
        this.setActionPerformed(false);
        TPFTestSuite testSuite = this.getTestSuite(this.getStructuredSelection());
        Set testCaseTypes = (Set)testCaseTypesByTestSuiteType.get(testSuite.getType());
        ArrayList<WizardElement> wizardElements = new ArrayList<WizardElement>(testCaseTypes.size());
        IAssociationMapping testCaseWizardMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
        Iterator i = testCaseTypes.iterator();
        while (i.hasNext()) {
            String testCaseType = (String)i.next();
            IAssociationDescriptor[] wizardDescriptors = testCaseWizardMapping.getAssociationDescriptors(testCaseType);
            int maxj = wizardDescriptors.length;
            for (int j = 0; j < maxj; ++j) {
                Object wizard = wizardDescriptors[j].createImplementationClassInstance();
                if (!(wizard instanceof ITestCaseWizard)) continue;
                WizardElement wizardElement = new WizardElement((IWizard)((ITestCaseWizard)wizard));
                wizardElement.setId(wizardDescriptors[j].getId());
                wizardElement.setLabel(wizardDescriptors[j].getName());
                wizardElement.setDescription(wizardDescriptors[j].getDescription());
                wizardElement.setImageDescriptor(wizardDescriptors[j].getImageDescriptor());
                wizardElements.add(wizardElement);
            }
        }
        SelectionWizard selectionWizard = new SelectionWizard(wizardElements.toArray(new IWizardElement[wizardElements.size()]), TestUIPlugin.getString("WIZ_SEL_TST_CASE"));
        selectionWizard.setWindowTitle(TestUIPlugin.getString("WIZ_TST_CASE_TTL"));
        this.openWizard(testSuite, (HyadesWizard)selectionWizard, "TestCaseSelectionWizard");
    }
}

