/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolExportCSVFileLocationPage;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolExportSelectionPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class DatapoolExportWizard
extends Wizard
implements IExportWizard {
    DatapoolExportSelectionPage datapoolSelectionPage = null;
    DatapoolExportCSVFileLocationPage csvFileLocationPage = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_TTL"));
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void addPages() {
        this.csvFileLocationPage = new DatapoolExportCSVFileLocationPage("csvFileSelection");
        this.csvFileLocationPage.setTitle(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_CSV_PG_TTL"));
        this.csvFileLocationPage.setDescription(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_CSV_PG_DSC"));
        this.addPage((IWizardPage)this.csvFileLocationPage);
        this.datapoolSelectionPage = new DatapoolExportSelectionPage("datapoolSelection");
        this.datapoolSelectionPage.setTitle(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_SEL_PG_TTL"));
        this.datapoolSelectionPage.setDescription(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_SEL_PG_DSC"));
        this.addPage((IWizardPage)this.datapoolSelectionPage);
    }

    public boolean canFinish() {
        return this.csvFileLocationPage.isPageComplete() && this.datapoolSelectionPage.isPageComplete();
    }

    public boolean performFinish() {
        IDatapool datapool = this.datapoolSelectionPage.getDatapool();
        String csvFileName = this.csvFileLocationPage.getCSVFileName();
        File file = new File(csvFileName);
        if (file.exists()) {
            Object[] messageElements = new Object[]{csvFileName, TestUIPlugin.getString("WIZ_EXP_DATAPOOL_MSG_EXISTS")};
            String message = MessageFormat.format("{0} {1}", messageElements);
            MessageDialog overwriteDialog = new MessageDialog(this.getShell(), TestUIPlugin.getString("WIZ_EXP_DATAPOOL_TTL"), null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (overwriteDialog.open() != 0) {
                return false;
            }
        }
        boolean exportVariables = this.csvFileLocationPage.getExportVariables();
        boolean exportEqClsNames = this.csvFileLocationPage.getExportEquivalenceClassNames();
        boolean exportTags = this.csvFileLocationPage.getExportTags();
        String exportEncoding = this.csvFileLocationPage.getExportEncoding();
        CSVImportExportUtil.getInstance().exportCSV(datapool, csvFileName, exportVariables, exportEqClsNames, exportTags, exportEncoding);
        return true;
    }
}

