/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * @author jtoomey
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class HyadesBVRInteractionAdapter extends AdapterImpl {

	/**
	 * 
	 */
	public HyadesBVRInteractionAdapter() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object obj) {
		if (obj instanceof EObject)
		{
		  return ((EObject)obj).eClass() == Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction();
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		
		int eventType = notification.getEventType();
		
		if(!(notification.getNotifier() instanceof EObject))
		{
			return;
		}
		EObject container = ((EObject)notification.getNotifier()).eContainer();
		if(container instanceof TPFBehavior)
		{
			container = container.eContainer();
		}
		if(!(container instanceof TPFTestSuite))
		{
			return;
		}
		if(!FacadeResourceFactoryImpl.PERSISTENCE_ID.equals(((TPFTestSuiteImpl)container).getPersistenceId()))
		{
			return;
		}
		
		if ( eventType == Notification.ADD ||
			 eventType == Notification.ADD_MANY ||
			 eventType == Notification.REMOVE ||
			 eventType == Notification.REMOVE_MANY)
		{
			switch (notification.getFeatureID(BVRInteraction.class))
			{
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
					BVRInteractionImpl interaction = (BVRInteractionImpl) notification.getNotifier();
					BVRInteractionFragmentImpl fragment = null;
					List fragments = null;
					TPFBehaviorImpl implementor = null;
					BVRLifelineImpl selfLifeline = null;
					BVRLifelineImpl lifeline = null;
					Iterator iter = null;
					List lifelines = null;
					Iterator itLifelines = null;
					TPFTestSuiteImpl testSuite = null;
					
					switch(eventType) {	
						case Notification.ADD:
							fragment = (BVRInteractionFragmentImpl)notification.getNewValue();	
							HyadesUtil.INSTANCE.createSUTInstances(interaction, fragment);

							// (Add the self lifeline to the the InteractionFragment's lifeline collection.
							// (Convention -- for MessageEnd, caller lifeline is first, then invoked lifeline.)					
//							implementor = (TPFBehaviorImpl)interaction.getBehavior();
//							selfLifeline = implementor.getSelfLifeline();
							// Add it to the front of the collection
//							fragment.getLifelines().add(0,selfLifeline); 
							
							if(fragment instanceof ITestInvocation)
							{
								ITestSuite test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)fragment).getInvokedTest());
								ITestSuite owner = (ITestSuite) EcoreUtil.getRootContainer(interaction);
							 	
							 	if(owner != null && test != null && !owner.getId().equals(test.getId()))
							 	{
									if(!HyadesUtil.INSTANCE.containsSuite(owner.getIReferencedSuites(), test))
									{
								 		owner.getIReferencedSuites().add(test);
									}
							 	}
							}
							
							break;
						case Notification.ADD_MANY:
							fragments = (List)notification.getNewValue();
							iter = fragments.iterator();
							while (iter.hasNext()) {
								fragment = (BVRInteractionFragmentImpl)iter.next();

								// (Add the self lifeline to the the InteractionFragment's lifeline collection.
								// (Convention -- for MessageEnd, caller lifeline is first, then invoked lifeline.)					
//								implementor = (TPFBehaviorImpl)interaction.getBehavior();
//								selfLifeline = implementor.getSelfLifeline();
								// Add it to the front of the collection
//								fragment.getLifelines().add(0,selfLifeline); 

								HyadesUtil.INSTANCE.createSUTInstances(interaction, fragment);
								if(fragment instanceof ITestInvocation)
								{
									ITestSuite test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)fragment).getInvokedTest());
									ITestSuite owner = (ITestSuite) EcoreUtil.getRootContainer(interaction);
							 	
									if(owner != null && test != null && !owner.getId().equals(test.getId()))
									{
										if(!HyadesUtil.INSTANCE.containsSuite(owner.getIReferencedSuites(), test))
										{
											owner.getIReferencedSuites().add(test);
										}
									}
								}
							}
							break;
						case Notification.REMOVE:
							fragment = (BVRInteractionFragmentImpl)notification.getOldValue();
							if(fragment instanceof ITestInvocation)
							{
								ITestSuite test = null;
								BVRExecutionOccurrenceImpl executionOccurrenceImpl = (BVRExecutionOccurrenceImpl)fragment;
								if((executionOccurrenceImpl.getOtherBehavior() != null) && (executionOccurrenceImpl.getOtherBehavior().eIsProxy()))
								{
									TPFBehavior behavior = (TPFBehavior)EcoreUtil.resolve(((BVRExecutionOccurrenceImpl)fragment).getOtherBehavior(), interaction.eResource().getResourceSet());
									if(behavior != null)
									{
										test = HyadesUtil.INSTANCE.getTestSuite((ITest)behavior.getTest());
									}
								}
								else
								{
									test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)fragment).getInvokedTest());
								}
								ITestSuite owner = HyadesUtil.INSTANCE.getTestSuite(((TPFBehaviorImpl)interaction.getBehavior()).getOwner());
									
								if(owner != null && test != null && !hasSuite(interaction.getInteractionFragments(), test, interaction))
								{
									owner.getIReferencedSuites().remove(test);
								}
							}

							// Iterate over all lifelines in the interaction, and remove 
							// any references to this interaction fragment from each of them.
							lifelines = interaction.getLifelines();
							itLifelines = lifelines.iterator();
							while ( itLifelines.hasNext() )
							{
								lifeline = (BVRLifelineImpl)itLifelines.next();
								lifeline.getInteractionFragments().remove(fragment);
							}
							break;
						case Notification.REMOVE_MANY:
							fragments = (List)notification.getOldValue();
							iter = fragments.iterator();
							while (iter.hasNext()) {
								fragment = (BVRInteractionFragmentImpl)iter.next();
								if(fragment instanceof ITestInvocation)
								{
									ITestSuite test = null;
									if(((BVRExecutionOccurrenceImpl)fragment).getOtherBehavior().eIsProxy())
									{
										TPFBehavior behavior = (TPFBehavior)EcoreUtil.resolve(((BVRExecutionOccurrenceImpl)fragment).getOtherBehavior(), interaction.eResource().getResourceSet());
										if(behavior != null)
										{
											test = HyadesUtil.INSTANCE.getTestSuite((ITest)behavior.getTest());
										}
									}
									else
									{
										test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)fragment).getInvokedTest());
									}
									ITestSuite owner = HyadesUtil.INSTANCE.getTestSuite(((TPFBehaviorImpl)interaction.getBehavior()).getOwner());
									
									if(owner != null && test != null && !hasSuite(interaction.getInteractionFragments(), test, interaction))
									{
										owner.getIReferencedSuites().remove(test);
									}
								}

								// Iterate over all lifelines in the interaction, and remove 
								// any references to this interaction fragment from each of them.
								lifelines = interaction.getLifelines();
								itLifelines = lifelines.iterator();
								while ( itLifelines.hasNext() )
								{
									lifeline = (BVRLifelineImpl)itLifelines.next();
									lifeline.getInteractionFragments().remove(fragment);
								}
							}											
							break;
					}					
				break;
			}			
		}
	}
		
	private boolean hasSuite(List otherInteractionFragments, ITestSuite suite, BVRInteraction interaction)
	{
		Iterator iter = otherInteractionFragments.iterator();
		while(iter.hasNext())
		{
			BVRInteractionFragmentImpl fragment = (BVRInteractionFragmentImpl)iter.next();
			if(fragment instanceof BVRExecutionOccurrenceImpl)
			{
				ITestSuite test = null;
				if(((BVRExecutionOccurrenceImpl)fragment).getOtherBehavior().eIsProxy())
				{
					TPFBehavior behavior = (TPFBehavior)EcoreUtil.resolve(((BVRExecutionOccurrenceImpl)fragment).getOtherBehavior(), interaction.eResource().getResourceSet());
					if(behavior != null)
					{
						test = HyadesUtil.INSTANCE.getTestSuite((ITest)behavior.getTest());
					}
				}
				else
				{
					test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)fragment).getInvokedTest());
				}
	
				if(test.getId().equals(suite.getId()))
				{
					return true;
				}
			}
		}
		return false;
	}
}
