/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;

/**
 * @author rduggan
 *
 * A specialized IComponent that manages a collection of IComponents
 * as a context.   Contexts exist as separate threads within the Adapter
 * 
 */
public interface IContext extends IComponent, Runnable {
	
	/**
	 * Set the IContextListener that will be invoked as the context
	 * manages its sub-components.  
	 * @param listener
	 */
	public void setContextListener(IContextListener listener);
	
	/**
	 * Get the IContextListener that is invoked as the context
	 * manages its sub-components.  
	 */
	public IContextListener getContextListener();

}
