/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.HashMap;
import java.util.List;

import org.eclipse.hyades.logging.adapter.AdapterException;
import org.w3c.dom.Element;

/**
 * This is the interface that all processing elements must adhere to.  IStatement
 * instances are first given a piece of configuration via the prepare method.  Once the
 * configuration is prepared then the IProcessingNode will be given requests to analyse a
 * piece of character data against the prepared statement
 * 
 * @author rduggan
 * @version 0.1
 * @since 0.1
 */
public interface IStatement {
	
	/**
	 * Prepare this IStatement for use.  
	 * @param node - the Node from the configuration that this IStatement is
	 *               responsable for handling.
	 */
	public void prepare(Element node, String path) throws PreparationException ;
	
	/**
	 * Run this IStatement against a specific character sequence.
	 * @param line
	 * @param env
	 * @return
	 */
	public boolean run(String line , HashMap inputs, List outputs) throws AdapterException;
	
}
