/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.List;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class generates an SQL CREATE INDEX statement.
 */
public class IndexStatement extends SQLStatement {
	protected EClass eClass;

	public IndexStatement(DatabaseType dbType,DBMap map, EClass eClass) {
		super(dbType,map);
		this.eClass = eClass;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.SQLStatement#getStatement()
	 */
	public String getStatement() {
		if (statement.length() != 0)
			return statement.toString();

		DBMap.ClassData data = (DBMap.ClassData) dbMap.getDBRepresentation(eClass);
		Table table = data.getTable();
		String indexName = getIndexName();
		String columnName = getColumnName();

		statement.append("CREATE INDEX ");
		statement.append(addQuotes(indexName));
		statement.append(" ON ");
		statement.append(addQuotes(table.getName()));
		statement.append(" (");
		statement.append(addQuotes(columnName));
		statement.append(")");//\n");

		return statement.toString();
	}

	protected String getIndexName() {
		EAttribute attribute = eClass.getEIDAttribute();
		DBMap.AttributeData data = (DBMap.AttributeData) dbMap.getDBRepresentation(attribute);
		List constraints = data.getValueColumn().getConstraints();

		for (int i = 0, l = constraints.size(); i < l; i++) {
			Constraint constraint = (Constraint) constraints.get(i);

			if (constraint.getType().equals(RDBHelper.INDEX_TYPE))
				return constraint.getName();
		}

		return null;
	}

	protected String getColumnName() {
		EAttribute attribute = eClass.getEIDAttribute();
		DBMap.AttributeData data = (DBMap.AttributeData) dbMap.getDBRepresentation(attribute);
		return data.getValueColumn().getName();
	}
} // IndexStatement
