/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class generates an SQL SELECT statement that counts the number of
 * referenced objects for the source object with the given id.
 */
public class ReferenceCountQuery extends QueryStatement {
	protected Column source;
	protected Column target;
	protected Integer id;

	public ReferenceCountQuery(DatabaseType type, DBMap map, Integer id, EReference reference) {
		super(type, map, reference);
		this.id = id;
		DBMap.ReferenceData data;
		data = (DBMap.ReferenceData) dbMap.getDBRepresentation(reference);
		source = data.getSourceColumn();
		target = data.getTargetColumn();
	}

	public String getStatement() {
		if (statement.length() != 0)
			return statement.toString();

		statement.append("SELECT COUNT(*) FROM ");
		statement.append(addQuotes(table.getName()));

		createWhereClause();
		return statement.toString();
	}

	protected void createWhereClause() {
		statement.append(" WHERE ");
		statement.append(addQuotes(table.getName()));
		statement.append(".");
		statement.append(addQuotes(source.getName()));
		statement.append(" = ");
		statement.append(id);
	}

	public EClass getEClass() {
		return null;
	}

	public String getKeyName() {
		return null;
	}
} // ReferenceQuery
