/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class updates the id table with the given largest database id. There is
 * always one row in the table. If there is no row, one is added; otherwise, the
 * existing row is updated.
 */
public class UpdateLargestDatabaseId extends DBCommand {
	protected int largestId;
	protected Table idTable;

	public UpdateLargestDatabaseId(JDBCHelper helper, DBMap map, int id) {
		super(helper, map);
		largestId = id;
		idTable = map.getIdTable();
	}

	public Object execute() throws Exception {
		PerfUtil p = new PerfUtil("UpdateLargestDatabaseId.execute id="+largestId,true);
		
		if (idTable == null)
			return null;

		int currentId = getCurrentId();

		if (currentId == 0)
			addId();
		else
			updateId(currentId);

		p.stopAndPrintStatus();
		return null;
	}

	protected int getCurrentId() throws Exception {
		DBCommand command = DBCommandFactory.INSTANCE.createGetLargestDatabaseId(helper, dbMap);
		Integer id = (Integer) command.execute();
		return id == null ? 0 : id.intValue();
	}

	protected void addId() throws Exception {
		String insert = createInsertStatement();
		helper.executeUpdateStatement(insert);
	}

	protected String createInsertStatement() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("INSERT INTO ");
		buffer.append(addQuotes(idTable.getName()));
		buffer.append(" (");
		buffer.append(addQuotes(((Column) idTable.getColumns().get(0)).getName()));
		buffer.append(") VALUES (");
		buffer.append(largestId);
		buffer.append(")");
		return buffer.toString();
	}

	protected void updateId(int current) throws Exception {
		String update = createUpdateStatement(current);
		helper.executeUpdateStatement(update);
	}

	protected String createUpdateStatement(int current) {
		StringBuffer buffer = new StringBuffer();
		buffer.append("UPDATE ");
		buffer.append(addQuotes(idTable.getName()));
		buffer.append(" SET ");
		Column id = (Column) idTable.getColumns().get(0);
		buffer.append(addQuotes(id.getName()));
		buffer.append(" = ");
		buffer.append(largestId);
		buffer.append(" WHERE ");
		buffer.append(addQuotes(id.getName()));
		buffer.append(" = ");
		buffer.append(current);
		return buffer.toString();
	}
} // UpdateLargestDatabaseId
