/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.wizard;

import java.util.Iterator;

import org.eclipse.hyades.sdb.internal.SDbPlugin;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewSymptomDBWizard extends Wizard implements INewWizard {

	private NewSymptomDBWizardPage page;	
	private String selFolder="";
	/**
	 * Constructor for NewSymptomDBWizard.
	 */
	public NewSymptomDBWizard() {
		super();
	}

	/**
	 * @see IWizard#performFinish()
	 */
	public boolean performFinish() {

		return page.performFinish();

	}
	

	public void addPages() {

	  	setWindowTitle(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD_TITLE"));
		super.addPages();
		page = new NewSymptomDBWizardPage(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD"));
		addPage(page);
		page.init(selFolder)		;
	}
	

	/**
	 * @see IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
	    
	    if (selection instanceof IStructuredSelection) {
	        Iterator enum = selection.iterator();
	        if (enum.hasNext()) {
	            Object obj = enum.next();
	            if (enum.hasNext()) // implies > 1 elements selection in tree, so we don't populate with selection
	                selFolder = "";
	            else {
	                IResource r = null;
	                if (obj instanceof IResource)
	                    r = (IResource)obj;
	
	                // pre-populate the wizard with the sel. resource (project, folder) or the container of the sel. resource(file)
	                if (r != null){
	                	if(r.getType() != IResource.FILE){
	                    	selFolder = r.getFullPath().toOSString();
	                	}
	                	else {
	                		selFolder = r.getFullPath().removeLastSegments(1).toOSString();
	                	}
	                }
	                		                    
	            }
	        }
	    }
		
	}

}
