/**********************************************************************
 * Copyright (c) 2003 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * This class handles the open action of a {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}
 * resource editor.
 * 
 * @author bjiang
 * @since	3.0
 */
public class OpenArtifactAction extends SelectionListenerAction
{
	private StructuredViewer structuredViewer;
	private boolean actionPerformed;
	
	/**
	 * Constructor for OpenArtifactAction
	 */
	public OpenArtifactAction()
	{
		super(TestUIPlugin.getString("BTN_OPEN")); //$NON-NLS-1$
	
		setToolTipText(TestUIPlugin.getString("ACT_ART_OPN_TIP"));
		setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_ARTIFACT));
	}
	
	/**
	 * Sets the action performed flag.
	 * @param actionPerformed
	 */
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPerformed = actionPerformed;
	}

	/**
	 * Returns whether the most run has being completed.  This information is reset 
	 * at the selection changes. 
	 * @return boolean.
	 */
	public boolean actionPerformed()
	{
		return actionPerformed;
	}

	/**
	 * Sets the structuredViewer that should be updated after running this action.
	 * @param structuredViewer
	 */
	public void setStructuredViewer(StructuredViewer structuredViewer)
	{
		this.structuredViewer = structuredViewer;
	}

	/**
	 * Returns the structuredViewer to be updated after running this action.
	 * @return structuredViewer
	 */
	public StructuredViewer getStructuredViewer()
	{
		return structuredViewer;
	}	
	
	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof CFGArtifact);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		IStructuredSelection selection = (IStructuredSelection)getStructuredViewer().getSelection();
		if( selection.size() == 1 && selection.getFirstElement() instanceof CFGArtifact)
		{
			IFile file = EMFUtil.getWorkspaceFile((EObject)selection.getFirstElement());
			UIUtil.openEditor(file, TestUIExtension.ARTIFACT_EDITOR_PART_ID, false);
		}		
	}
}
