/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.action.AddTestAssetAction;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenDownAction;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenUpAction;
import org.eclipse.hyades.test.ui.action.model.RemoveFeatureChildrenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * This class implements the test assets tab of the Artifact editor
 * to edit {@link org.eclipse.hyades.models.common.configuration.CFGArtifact} association
 * with test assets {@link org.eclipse.hyades.models.common.configuration.CFGClass}.
 * 
 * @author bjiang
 * @since  3.0
 */
public class TestAssetsForm extends EditorForm implements ISelectionChangedListener
{
	private ExtensibleEObjectTreeSection testAssetsSection;
	private AddTestAssetAction addTestAssetAction;
	
    /**
     * @param baseEditorExtension
     * @param widgetFactory
     */
    public TestAssetsForm(BaseEditorExtension baseEditorExtension,
            WidgetFactory widgetFactory)
    {
        super(baseEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_ARTIFACT"));
    }
    
    /**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		if(testAssetsSection != null)
		{
		    testAssetsSection.dispose();
		    testAssetsSection = null;
		}
		super.dispose();
	}

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.editor.form.util.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
     */
    protected void createEditorFormContents(Composite parent)
    {
        GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);
		Control control;

		Composite artifactsColumn = createColumn(parent);
		Composite locationsColumn = createColumn(parent);	
		
		IAction[] buttonActions = createButtonActions();
		testAssetsSection = new ExtensibleEObjectTreeSection(this, Common_ConfigurationPackage.eINSTANCE.getCFGArtifact_DeployableInstances(), buttonActions);
		registerSection(testAssetsSection);
		testAssetsSection.setHeaderText(TestUIPlugin.getString("W_TEST_ASSETS"));
		testAssetsSection.setCollapsable(true);
		control = testAssetsSection.createControl(artifactsColumn, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));
		testAssetsSection.setEditable(true);	
		for(int i = 0; i < buttonActions.length; i++)
		{
		    IAction action = buttonActions[i];
		    if(action != null && action instanceof ChildrenSelectionAction)
		        ((ChildrenSelectionAction)action).setStructuredViewer(testAssetsSection.getTreeViewer());
		}
    }
    
    private IAction[] createButtonActions()
    {
        IAction[] buttonActions = new IAction[4];
		buttonActions[0] = addTestAssetAction = new AddTestAssetAction();
		buttonActions[1] = new RemoveFeatureChildrenAction(getEditorObject(), Common_ConfigurationPackage.eINSTANCE.getCFGArtifact_DeployableInstances(), false);	
		buttonActions[2] = new MoveFeatureChildrenUpAction(getEditorObject(), Common_ConfigurationPackage.eINSTANCE.getCFGArtifact_DeployableInstances());
		buttonActions[3] = new MoveFeatureChildrenDownAction(getEditorObject(), Common_ConfigurationPackage.eINSTANCE.getCFGArtifact_DeployableInstances());
		return buttonActions;
    }
    
    /**
	 * Returns the {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment} object that is edited by this form.
	 * @return EObject 
	 */
	protected EObject getEditorObject()
	{
		return ((ConfigurableObjectEditorExtension)getBaseEditorExtension()).getEditorObject();
	}

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.editor.form.util.EditorForm#load()
     */
    public void load()
    {
        CFGArtifact artifact = (CFGArtifact)getEditorObject();
        addTestAssetAction.setArtifact(artifact);
        //testAssetsSection.getTreeViewer().removeSelectionChangedListener(this);
        testAssetsSection.setInput(artifact);
        //testAssetsSection.getTreeViewer().addSelectionChangedListener(this);
    }
    
	public ISelection getSelection()
	{
		return testAssetsSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
	    testAssetsSection.selectReveal(selection);
	}

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event)
    {
        // TODO Auto-generated method stub

    }

}
